@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyServerTimingHeadersConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled A Whether CloudFront adds the `Server-Timing` header to HTTP responses that it sends in response to requests that match a cache behavior that's associated with this response headers policy.
 * @property samplingRate A number 0–100 (inclusive) that specifies the percentage of responses that you want CloudFront to add the Server-Timing header to. Valid range: Minimum value of 0.0. Maximum value of 100.0.
 */
public data class ResponseHeadersPolicyServerTimingHeadersConfigArgs(
    public val enabled: Output<Boolean>,
    public val samplingRate: Output<Double>,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyServerTimingHeadersConfigArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyServerTimingHeadersConfigArgs =
        com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyServerTimingHeadersConfigArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .samplingRate(samplingRate.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResponseHeadersPolicyServerTimingHeadersConfigArgs].
 */
@PulumiTagMarker
public class ResponseHeadersPolicyServerTimingHeadersConfigArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var samplingRate: Output<Double>? = null

    /**
     * @param value A Whether CloudFront adds the `Server-Timing` header to HTTP responses that it sends in response to requests that match a cache behavior that's associated with this response headers policy.
     */
    @JvmName("ulhdhdfnicdvnesc")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value A number 0–100 (inclusive) that specifies the percentage of responses that you want CloudFront to add the Server-Timing header to. Valid range: Minimum value of 0.0. Maximum value of 100.0.
     */
    @JvmName("injddeptcsrjyljk")
    public suspend fun samplingRate(`value`: Output<Double>) {
        this.samplingRate = value
    }

    /**
     * @param value A Whether CloudFront adds the `Server-Timing` header to HTTP responses that it sends in response to requests that match a cache behavior that's associated with this response headers policy.
     */
    @JvmName("kgrbuijxadulloiy")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value A number 0–100 (inclusive) that specifies the percentage of responses that you want CloudFront to add the Server-Timing header to. Valid range: Minimum value of 0.0. Maximum value of 100.0.
     */
    @JvmName("yevrbdawowxkuwvn")
    public suspend fun samplingRate(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.samplingRate = mapped
    }

    internal fun build(): ResponseHeadersPolicyServerTimingHeadersConfigArgs =
        ResponseHeadersPolicyServerTimingHeadersConfigArgs(
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
            samplingRate = samplingRate ?: throw PulumiNullFieldException("samplingRate"),
        )
}
