@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property cookiesConfig Whether any cookies in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin. See Cookies Config for more information.
 * @property enableAcceptEncodingBrotli Flag determines whether the Accept-Encoding HTTP header is included in the cache key and in requests that CloudFront sends to the origin.
 * @property enableAcceptEncodingGzip Whether the Accept-Encoding HTTP header is included in the cache key and in requests sent to the origin by CloudFront.
 * @property headersConfig Whether any HTTP headers are included in the cache key and automatically included in requests that CloudFront sends to the origin. See Headers Config for more information.
 * @property queryStringsConfig Whether any URL query strings in viewer requests are included in the cache key. It also automatically includes these query strings in requests that CloudFront sends to the origin. Please refer to the Query String Config for more information.
 */
public data class CachePolicyParametersInCacheKeyAndForwardedToOrigin(
    public val cookiesConfig: CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfig,
    public val enableAcceptEncodingBrotli: Boolean? = null,
    public val enableAcceptEncodingGzip: Boolean? = null,
    public val headersConfig: CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfig,
    public val queryStringsConfig: CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfig,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.CachePolicyParametersInCacheKeyAndForwardedToOrigin): CachePolicyParametersInCacheKeyAndForwardedToOrigin =
            CachePolicyParametersInCacheKeyAndForwardedToOrigin(
                cookiesConfig = javaType.cookiesConfig().let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfig.Companion.toKotlin(args0)
                }),
                enableAcceptEncodingBrotli = javaType.enableAcceptEncodingBrotli().map({ args0 ->
                    args0
                }).orElse(null),
                enableAcceptEncodingGzip = javaType.enableAcceptEncodingGzip().map({ args0 -> args0 }).orElse(null),
                headersConfig = javaType.headersConfig().let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfig.Companion.toKotlin(args0)
                }),
                queryStringsConfig = javaType.queryStringsConfig().let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfig.Companion.toKotlin(args0)
                }),
            )
    }
}
