@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property headerBehavior Whether any HTTP headers are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values for `header_behavior` are `none` and `whitelist`.
 * @property headers Object contains a list of header names. See Items for more information.
 */
public data class CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfig(
    public val headerBehavior: String? = null,
    public val headers: CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeaders? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfig): CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfig =
            CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfig(
                headerBehavior = javaType.headerBehavior().map({ args0 -> args0 }).orElse(null),
                headers = javaType.headers().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cloudfront.kotlin.outputs.CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeaders.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
