@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property queryStringBehavior Whether URL query strings in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values for `query_string_behavior` are `none`, `whitelist`, `allExcept`, and `all`.
 * @property queryStrings Configuration parameter that contains a list of query string names. See Items for more information.
 */
public data class CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfig(
    public val queryStringBehavior: String,
    public val queryStrings: CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryStrings? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfig): CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfig =
            CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfig(
                queryStringBehavior = javaType.queryStringBehavior(),
                queryStrings = javaType.queryStrings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cloudfront.kotlin.outputs.CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryStrings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
