@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 *
 * @property sessionStickinessConfig Session stickiness provides the ability to define multiple requests from a single viewer as a single session. This prevents the potentially inconsistent experience of sending some of a given user's requests to the staging distribution, while others are sent to the primary distribution. Define the session duration using TTL values. See `session_stickiness_config`.
 * @property weight The percentage of traffic to send to a staging distribution, expressed as a decimal number between `0` and `.15`.
 */
public data class ContinuousDeploymentPolicyTrafficConfigSingleWeightConfig(
    public val sessionStickinessConfig: ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfig? = null,
    public val weight: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfig): ContinuousDeploymentPolicyTrafficConfigSingleWeightConfig =
            ContinuousDeploymentPolicyTrafficConfigSingleWeightConfig(
                sessionStickinessConfig = javaType.sessionStickinessConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cloudfront.kotlin.outputs.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                weight = javaType.weight(),
            )
    }
}
