@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cookies The forwarded values cookies that specifies how CloudFront handles cookies (maximum one).
 * @property headers Headers, if any, that you want CloudFront to vary upon for this cache behavior. Specify `*` to include all headers.
 * @property queryString Indicates whether you want CloudFront to forward query strings to the origin that is associated with this cache behavior.
 * @property queryStringCacheKeys When specified, along with a value of `true` for `query_string`, all query strings are forwarded, however only the query string keys listed in this argument are cached. When omitted with a value of `true` for `query_string`, all query string keys are cached.
 */
public data class DistributionDefaultCacheBehaviorForwardedValues(
    public val cookies: DistributionDefaultCacheBehaviorForwardedValuesCookies,
    public val headers: List<String>? = null,
    public val queryString: Boolean,
    public val queryStringCacheKeys: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.DistributionDefaultCacheBehaviorForwardedValues): DistributionDefaultCacheBehaviorForwardedValues =
            DistributionDefaultCacheBehaviorForwardedValues(
                cookies = javaType.cookies().let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.DistributionDefaultCacheBehaviorForwardedValuesCookies.Companion.toKotlin(args0)
                }),
                headers = javaType.headers().map({ args0 -> args0 }),
                queryString = javaType.queryString(),
                queryStringCacheKeys = javaType.queryStringCacheKeys().map({ args0 -> args0 }),
            )
    }
}
