@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property httpPort HTTP port the custom origin listens on.
 * @property httpsPort HTTPS port the custom origin listens on.
 * @property originKeepaliveTimeout The Custom KeepAlive timeout, in seconds. By default, AWS enforces an upper limit of `60`. But you can request an [increase](http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/RequestAndResponseBehaviorCustomOrigin.html#request-custom-request-timeout). Defaults to `5`.
 * @property originProtocolPolicy Origin protocol policy to apply to your origin. One of `http-only`, `https-only`, or `match-viewer`.
 * @property originReadTimeout The Custom Read timeout, in seconds. By default, AWS enforces an upper limit of `60`. But you can request an [increase](http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/RequestAndResponseBehaviorCustomOrigin.html#request-custom-request-timeout). Defaults to `30`.
 * @property originSslProtocols List of SSL/TLS protocols that CloudFront can use when connecting to your origin over HTTPS. Valid values: `SSLv3`, `TLSv1`, `TLSv1.1`, `TLSv1.2`. For more information, see [Minimum Origin SSL Protocol](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols) in the Amazon CloudFront Developer Guide.
 */
public data class DistributionOriginCustomOriginConfig(
    public val httpPort: Int,
    public val httpsPort: Int,
    public val originKeepaliveTimeout: Int? = null,
    public val originProtocolPolicy: String,
    public val originReadTimeout: Int? = null,
    public val originSslProtocols: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.DistributionOriginCustomOriginConfig): DistributionOriginCustomOriginConfig = DistributionOriginCustomOriginConfig(
            httpPort = javaType.httpPort(),
            httpsPort = javaType.httpsPort(),
            originKeepaliveTimeout = javaType.originKeepaliveTimeout().map({ args0 -> args0 }).orElse(null),
            originProtocolPolicy = javaType.originProtocolPolicy(),
            originReadTimeout = javaType.originReadTimeout().map({ args0 -> args0 }).orElse(null),
            originSslProtocols = javaType.originSslProtocols().map({ args0 -> args0 }),
        )
    }
}
