@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property locations [ISO 3166-1-alpha-2 codes][4] for which you want CloudFront either to distribute your content (`whitelist`) or not distribute your content (`blacklist`). If the type is specified as `none` an empty array can be used.
 * @property restrictionType Method that you want to use to restrict distribution of your content by country: `none`, `whitelist`, or `blacklist`.
 */
public data class DistributionRestrictionsGeoRestriction(
    public val locations: List<String>? = null,
    public val restrictionType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.DistributionRestrictionsGeoRestriction): DistributionRestrictionsGeoRestriction = DistributionRestrictionsGeoRestriction(
            locations = javaType.locations().map({ args0 -> args0 }),
            restrictionType = javaType.restrictionType(),
        )
    }
}
