@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property enabled `true` if any of the AWS accounts listed as trusted signers have active CloudFront key pairs
 * @property items List of nested attributes for each trusted signer
 */
public data class DistributionTrustedKeyGroup(
    public val enabled: Boolean? = null,
    public val items: List<DistributionTrustedKeyGroupItem>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.DistributionTrustedKeyGroup): DistributionTrustedKeyGroup = DistributionTrustedKeyGroup(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            items = javaType.items().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.DistributionTrustedKeyGroupItem.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
