@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property keyGroupId ID of the key group that contains the public keys.
 * @property keyPairIds Set of active CloudFront key pairs associated with the signer account
 */
public data class DistributionTrustedKeyGroupItem(
    public val keyGroupId: String? = null,
    public val keyPairIds: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.DistributionTrustedKeyGroupItem): DistributionTrustedKeyGroupItem = DistributionTrustedKeyGroupItem(
            keyGroupId = javaType.keyGroupId().map({ args0 -> args0 }).orElse(null),
            keyPairIds = javaType.keyPairIds().map({ args0 -> args0 }),
        )
    }
}
