@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property awsAccountNumber AWS account ID or `self`
 * @property keyPairIds Set of active CloudFront key pairs associated with the signer account
 */
public data class DistributionTrustedSignerItem(
    public val awsAccountNumber: String? = null,
    public val keyPairIds: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.DistributionTrustedSignerItem): DistributionTrustedSignerItem = DistributionTrustedSignerItem(
            awsAccountNumber = javaType.awsAccountNumber().map({ args0 -> args0 }).orElse(null),
            keyPairIds = javaType.keyPairIds().map({ args0 -> args0 }),
        )
    }
}
