@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property acmCertificateArn ARN of the [AWS Certificate Manager](https://aws.amazon.com/certificate-manager/) certificate that you wish to use with this distribution. Specify this, `cloudfront_default_certificate`, or `iam_certificate_id`.  The ACM certificate must be in  US-EAST-1.
 * @property cloudfrontDefaultCertificate `true` if you want viewers to use HTTPS to request your objects and you're using the CloudFront domain name for your distribution. Specify this, `acm_certificate_arn`, or `iam_certificate_id`.
 * @property iamCertificateId IAM certificate identifier of the custom viewer certificate for this distribution if you are using a custom domain. Specify this, `acm_certificate_arn`, or `cloudfront_default_certificate`.
 * @property minimumProtocolVersion Minimum version of the SSL protocol that you want CloudFront to use for HTTPS connections. Can only be set if `cloudfront_default_certificate = false`. See all possible values in [this](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html) table under "Security policy." Some examples include: `TLSv1.2_2019` and `TLSv1.2_2021`. Default: `TLSv1`. **NOTE**: If you are using a custom certificate (specified with `acm_certificate_arn` or `iam_certificate_id`), and have specified `sni-only` in `ssl_support_method`, `TLSv1` or later must be specified. If you have specified `vip` in `ssl_support_method`, only `SSLv3` or `TLSv1` can be specified. If you have specified `cloudfront_default_certificate`, `TLSv1` must be specified.
 * @property sslSupportMethod How you want CloudFront to serve HTTPS requests. One of `vip`, `sni-only`, or `static-ip`. Required if you specify `acm_certificate_arn` or `iam_certificate_id`. **NOTE:** `vip` causes CloudFront to use a dedicated IP address and may incur extra charges.
 */
public data class DistributionViewerCertificate(
    public val acmCertificateArn: String? = null,
    public val cloudfrontDefaultCertificate: Boolean? = null,
    public val iamCertificateId: String? = null,
    public val minimumProtocolVersion: String? = null,
    public val sslSupportMethod: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.DistributionViewerCertificate): DistributionViewerCertificate = DistributionViewerCertificate(
            acmCertificateArn = javaType.acmCertificateArn().map({ args0 -> args0 }).orElse(null),
            cloudfrontDefaultCertificate = javaType.cloudfrontDefaultCertificate().map({ args0 ->
                args0
            }).orElse(null),
            iamCertificateId = javaType.iamCertificateId().map({ args0 -> args0 }).orElse(null),
            minimumProtocolVersion = javaType.minimumProtocolVersion().map({ args0 -> args0 }).orElse(null),
            sslSupportMethod = javaType.sslSupportMethod().map({ args0 -> args0 }).orElse(null),
        )
    }
}
