@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property contentType he content type for a field-level encryption content type-profile mapping. Valid value is `application/x-www-form-urlencoded`.
 * @property format The format for a field-level encryption content type-profile mapping. Valid value is `URLEncoded`.
 * @property profileId
 */
public data class FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesItem(
    public val contentType: String,
    public val format: String,
    public val profileId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesItem): FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesItem =
            FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesItem(
                contentType = javaType.contentType(),
                format = javaType.format(),
                profileId = javaType.profileId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
