@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property forwardWhenQueryArgProfileIsUnknown Flag to set if you want a request to be forwarded to the origin even if the profile specified by the field-level encryption query argument, fle-profile, is unknown.
 * @property queryArgProfiles Object that contains an attribute `items` that contains the list ofrofiles specified for query argument-profile mapping for field-level encryption. see Query Arg Profile.
 */
public data class FieldLevelEncryptionConfigQueryArgProfileConfig(
    public val forwardWhenQueryArgProfileIsUnknown: Boolean,
    public val queryArgProfiles: FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfiles? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.FieldLevelEncryptionConfigQueryArgProfileConfig): FieldLevelEncryptionConfigQueryArgProfileConfig =
            FieldLevelEncryptionConfigQueryArgProfileConfig(
                forwardWhenQueryArgProfileIsUnknown = javaType.forwardWhenQueryArgProfileIsUnknown(),
                queryArgProfiles = javaType.queryArgProfiles().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cloudfront.kotlin.outputs.FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfiles.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
