@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property fieldPatterns Object that contains an attribute `items` that contains the list of field patterns in a field-level encryption content type profile specify the fields that you want to be encrypted.
 * @property providerId The provider associated with the public key being used for encryption.
 * @property publicKeyId The public key associated with a set of field-level encryption patterns, to be used when encrypting the fields that match the patterns.
 */
public data class FieldLevelEncryptionProfileEncryptionEntitiesItem(
    public val fieldPatterns: FieldLevelEncryptionProfileEncryptionEntitiesItemFieldPatterns,
    public val providerId: String,
    public val publicKeyId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.FieldLevelEncryptionProfileEncryptionEntitiesItem): FieldLevelEncryptionProfileEncryptionEntitiesItem =
            FieldLevelEncryptionProfileEncryptionEntitiesItem(
                fieldPatterns = javaType.fieldPatterns().let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.FieldLevelEncryptionProfileEncryptionEntitiesItemFieldPatterns.Companion.toKotlin(args0)
                }),
                providerId = javaType.providerId(),
                publicKeyId = javaType.publicKeyId(),
            )
    }
}
