@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cookiesConfigs Object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the cache key and automatically included in requests that CloudFront sends to the origin. See Cookies Config for more information.
 * @property enableAcceptEncodingBrotli A flag that can affect whether the Accept-Encoding HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
 * @property enableAcceptEncodingGzip A flag that can affect whether the Accept-Encoding HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
 * @property headersConfigs Object that determines whether any HTTP headers (and if so, which headers) are included in the cache key and automatically included in requests that CloudFront sends to the origin. See Headers Config for more information.
 * @property queryStringsConfigs Object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the cache key and automatically included in requests that CloudFront sends to the origin. See Query String Config for more information.
 */
public data class GetCachePolicyParametersInCacheKeyAndForwardedToOrigin(
    public val cookiesConfigs: List<GetCachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfig>,
    public val enableAcceptEncodingBrotli: Boolean,
    public val enableAcceptEncodingGzip: Boolean,
    public val headersConfigs: List<GetCachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfig>,
    public val queryStringsConfigs: List<GetCachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfig>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.GetCachePolicyParametersInCacheKeyAndForwardedToOrigin): GetCachePolicyParametersInCacheKeyAndForwardedToOrigin =
            GetCachePolicyParametersInCacheKeyAndForwardedToOrigin(
                cookiesConfigs = javaType.cookiesConfigs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cloudfront.kotlin.outputs.GetCachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfig.Companion.toKotlin(args0)
                    })
                }),
                enableAcceptEncodingBrotli = javaType.enableAcceptEncodingBrotli(),
                enableAcceptEncodingGzip = javaType.enableAcceptEncodingGzip(),
                headersConfigs = javaType.headersConfigs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cloudfront.kotlin.outputs.GetCachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfig.Companion.toKotlin(args0)
                    })
                }),
                queryStringsConfigs = javaType.queryStringsConfigs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cloudfront.kotlin.outputs.GetCachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfig.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
