@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cookieBehavior Determines whether any cookies in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values are `none`, `whitelist`, `allExcept`, `all`.
 * @property cookies Object that contains a list of cookie names. See Items for more information.
 */
public data class GetCachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfig(
    public val cookieBehavior: String,
    public val cookies: List<GetCachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookie>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.GetCachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfig): GetCachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfig =
            GetCachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfig(
                cookieBehavior = javaType.cookieBehavior(),
                cookies = javaType.cookies().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cloudfront.kotlin.outputs.GetCachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookie.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
