@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getDistribution.
 * @property aliases List that contains information about CNAMEs (alternate domain names), if any, for this distribution.
 * @property arn ARN (Amazon Resource Name) for the distribution. For example: arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5, where 123456789012 is your AWS account ID.
 * @property domainName Domain name corresponding to the distribution. For
 * example: `d604721fxaaqy9.cloudfront.net`.
 * @property enabled
 * @property etag Current version of the distribution's information. For example:
 * `E2QWRUHAPOMQZL`.
 * @property hostedZoneId CloudFront Route 53 zone ID that can be used to
 * route an [Alias Resource Record Set][7] to. This attribute is simply an
 * alias for the zone ID `Z2FDTNDATAQYW2`.
 * @property id Identifier for the distribution. For example: `EDFDVBD632BHDS5`.
 * @property inProgressValidationBatches The number of invalidation batches
 * currently in progress.
 * @property lastModifiedTime Date and time the distribution was last modified.
 * @property status Current status of the distribution. `Deployed` if the
 * distribution's information is fully propagated throughout the Amazon
 * CloudFront system.
 * @property tags
 * @property webAclId AWS WAF web ACL associated with this distribution.
 */
public data class GetDistributionResult(
    public val aliases: List<String>,
    public val arn: String,
    public val domainName: String,
    public val enabled: Boolean,
    public val etag: String,
    public val hostedZoneId: String,
    public val id: String,
    public val inProgressValidationBatches: Int,
    public val lastModifiedTime: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val webAclId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.GetDistributionResult): GetDistributionResult = GetDistributionResult(
            aliases = javaType.aliases().map({ args0 -> args0 }),
            arn = javaType.arn(),
            domainName = javaType.domainName(),
            enabled = javaType.enabled(),
            etag = javaType.etag(),
            hostedZoneId = javaType.hostedZoneId(),
            id = javaType.id(),
            inProgressValidationBatches = javaType.inProgressValidationBatches(),
            lastModifiedTime = javaType.lastModifiedTime(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            webAclId = javaType.webAclId(),
        )
    }
}
