@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getFunction.
 * @property arn ARN identifying your CloudFront Function.
 * @property code Source code of the function
 * @property comment Comment.
 * @property etag ETag hash of the function
 * @property id The provider-assigned unique ID for this managed resource.
 * @property keyValueStoreAssociations List of `aws.cloudfront.KeyValueStore` ARNs associated to the function.
 * @property lastModifiedTime When this resource was last modified.
 * @property name
 * @property runtime Identifier of the function's runtime.
 * @property stage
 * @property status Status of the function. Can be `UNPUBLISHED`, `UNASSOCIATED` or `ASSOCIATED`.
 */
public data class GetFunctionResult(
    public val arn: String,
    public val code: String,
    public val comment: String,
    public val etag: String,
    public val id: String,
    public val keyValueStoreAssociations: List<String>,
    public val lastModifiedTime: String,
    public val name: String,
    public val runtime: String,
    public val stage: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.GetFunctionResult): GetFunctionResult = GetFunctionResult(
            arn = javaType.arn(),
            code = javaType.code(),
            comment = javaType.comment(),
            etag = javaType.etag(),
            id = javaType.id(),
            keyValueStoreAssociations = javaType.keyValueStoreAssociations().map({ args0 -> args0 }),
            lastModifiedTime = javaType.lastModifiedTime(),
            name = javaType.name(),
            runtime = javaType.runtime(),
            stage = javaType.stage(),
            status = javaType.status(),
        )
    }
}
