@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getOriginAccessControl.
 * @property description A description of the origin access control.
 * @property etag Current version of the origin access control's information. For example: `E2QWRUHAPOMQZL`.
 * @property id
 * @property name A name to identify the origin access control.
 * @property originAccessControlOriginType The type of origin that this origin access control is for.
 * @property signingBehavior Specifies which requests CloudFront signs.
 * @property signingProtocol The signing protocol of the origin access control, which determines how CloudFront signs (authenticates) requests.
 */
public data class GetOriginAccessControlResult(
    public val description: String,
    public val etag: String,
    public val id: String,
    public val name: String,
    public val originAccessControlOriginType: String,
    public val signingBehavior: String,
    public val signingProtocol: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.GetOriginAccessControlResult): GetOriginAccessControlResult = GetOriginAccessControlResult(
            description = javaType.description(),
            etag = javaType.etag(),
            id = javaType.id(),
            name = javaType.name(),
            originAccessControlOriginType = javaType.originAccessControlOriginType(),
            signingBehavior = javaType.signingBehavior(),
            signingProtocol = javaType.signingProtocol(),
        )
    }
}
