@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getOriginAccessIdentities.
 * @property comments
 * @property iamArns Set of ARNs of the matched origin access identities.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids Set of ids of the matched origin access identities.
 * @property s3CanonicalUserIds Set of S3 canonical user IDs of the matched origin access identities.
 */
public data class GetOriginAccessIdentitiesResult(
    public val comments: List<String>? = null,
    public val iamArns: List<String>,
    public val id: String,
    public val ids: List<String>,
    public val s3CanonicalUserIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.GetOriginAccessIdentitiesResult): GetOriginAccessIdentitiesResult = GetOriginAccessIdentitiesResult(
            comments = javaType.comments().map({ args0 -> args0 }),
            iamArns = javaType.iamArns().map({ args0 -> args0 }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            s3CanonicalUserIds = javaType.s3CanonicalUserIds().map({ args0 -> args0 }),
        )
    }
}
