@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getOriginAccessIdentity.
 * @property callerReference Internal value used by CloudFront to allow future
 * updates to the origin access identity.
 * @property cloudfrontAccessIdentityPath A shortcut to the full path for the
 * origin access identity to use in CloudFront, see below.
 * @property comment An optional comment for the origin access identity.
 * @property etag Current version of the origin access identity's information.
 * For example: `E2QWRUHAPOMQZL`.
 * @property iamArn Pre-generated ARN for use in S3 bucket policies (see below).
 * Example: `arn:aws:iam::cloudfront:user/CloudFront Origin Access Identity
 * E2QWRUHAPOMQZL`.
 * @property id
 * @property s3CanonicalUserId The Amazon S3 canonical user ID for the origin
 * access identity, which you use when giving the origin access identity read
 * permission to an object in Amazon S3.
 */
public data class GetOriginAccessIdentityResult(
    public val callerReference: String,
    public val cloudfrontAccessIdentityPath: String,
    public val comment: String,
    public val etag: String,
    public val iamArn: String,
    public val id: String,
    public val s3CanonicalUserId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.GetOriginAccessIdentityResult): GetOriginAccessIdentityResult = GetOriginAccessIdentityResult(
            callerReference = javaType.callerReference(),
            cloudfrontAccessIdentityPath = javaType.cloudfrontAccessIdentityPath(),
            comment = javaType.comment(),
            etag = javaType.etag(),
            iamArn = javaType.iamArn(),
            id = javaType.id(),
            s3CanonicalUserId = javaType.s3CanonicalUserId(),
        )
    }
}
