@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getOriginRequestPolicy.
 * @property comment Comment to describe the origin request policy.
 * @property cookiesConfigs Object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the origin request key and automatically included in requests that CloudFront sends to the origin. See Cookies Config for more information.
 * @property etag Current version of the origin request policy.
 * @property headersConfigs Object that determines whether any HTTP headers (and if so, which headers) are included in the origin request key and automatically included in requests that CloudFront sends to the origin. See Headers Config for more information.
 * @property id
 * @property name
 * @property queryStringsConfigs Object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the origin request key and automatically included in requests that CloudFront sends to the origin. See Query String Config for more information.
 */
public data class GetOriginRequestPolicyResult(
    public val comment: String,
    public val cookiesConfigs: List<GetOriginRequestPolicyCookiesConfig>,
    public val etag: String,
    public val headersConfigs: List<GetOriginRequestPolicyHeadersConfig>,
    public val id: String? = null,
    public val name: String? = null,
    public val queryStringsConfigs: List<GetOriginRequestPolicyQueryStringsConfig>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.GetOriginRequestPolicyResult): GetOriginRequestPolicyResult = GetOriginRequestPolicyResult(
            comment = javaType.comment(),
            cookiesConfigs = javaType.cookiesConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.GetOriginRequestPolicyCookiesConfig.Companion.toKotlin(args0)
                })
            }),
            etag = javaType.etag(),
            headersConfigs = javaType.headersConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.GetOriginRequestPolicyHeadersConfig.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            queryStringsConfigs = javaType.queryStringsConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.GetOriginRequestPolicyQueryStringsConfig.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
