@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accessControlAllowCredentials A Boolean value that CloudFront uses as the value for the Access-Control-Allow-Credentials HTTP response header.
 * @property accessControlAllowHeaders Object that contains an attribute `items` that contains a list of HTTP header names that CloudFront includes as values for the Access-Control-Allow-Headers HTTP response header.
 * @property accessControlAllowMethods Object that contains an attribute `items` that contains a list of HTTP methods that CloudFront includes as values for the Access-Control-Allow-Methods HTTP response header. Valid values: `GET` | `POST` | `OPTIONS` | `PUT` | `DELETE` | `HEAD` | `ALL`
 * @property accessControlAllowOrigins Object that contains an attribute `items` that contains a list of origins that CloudFront can use as the value for the Access-Control-Allow-Origin HTTP response header.
 * @property accessControlExposeHeaders Object that contains an attribute `items` that contains a list of HTTP headers that CloudFront includes as values for the Access-Control-Expose-Headers HTTP response header.
 * @property accessControlMaxAgeSec A number that CloudFront uses as the value for the max-age directive in the Strict-Transport-Security HTTP response header.
 * @property originOverride
 */
public data class GetResponseHeadersPolicyCorsConfig(
    public val accessControlAllowCredentials: Boolean,
    public val accessControlAllowHeaders: List<GetResponseHeadersPolicyCorsConfigAccessControlAllowHeader>,
    public val accessControlAllowMethods: List<GetResponseHeadersPolicyCorsConfigAccessControlAllowMethod>,
    public val accessControlAllowOrigins: List<GetResponseHeadersPolicyCorsConfigAccessControlAllowOrigin>,
    public val accessControlExposeHeaders: List<GetResponseHeadersPolicyCorsConfigAccessControlExposeHeader>,
    public val accessControlMaxAgeSec: Int,
    public val originOverride: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.GetResponseHeadersPolicyCorsConfig): GetResponseHeadersPolicyCorsConfig = GetResponseHeadersPolicyCorsConfig(
            accessControlAllowCredentials = javaType.accessControlAllowCredentials(),
            accessControlAllowHeaders = javaType.accessControlAllowHeaders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.GetResponseHeadersPolicyCorsConfigAccessControlAllowHeader.Companion.toKotlin(args0)
                })
            }),
            accessControlAllowMethods = javaType.accessControlAllowMethods().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.GetResponseHeadersPolicyCorsConfigAccessControlAllowMethod.Companion.toKotlin(args0)
                })
            }),
            accessControlAllowOrigins = javaType.accessControlAllowOrigins().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.GetResponseHeadersPolicyCorsConfigAccessControlAllowOrigin.Companion.toKotlin(args0)
                })
            }),
            accessControlExposeHeaders = javaType.accessControlExposeHeaders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.GetResponseHeadersPolicyCorsConfigAccessControlExposeHeader.Companion.toKotlin(args0)
                })
            }),
            accessControlMaxAgeSec = javaType.accessControlMaxAgeSec(),
            originOverride = javaType.originOverride(),
        )
    }
}
