@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property contentSecurityPolicies The policy directives and their values that CloudFront includes as values for the Content-Security-Policy HTTP response header.
 * @property contentTypeOptions A setting that determines whether CloudFront includes the X-Content-Type-Options HTTP response header with its value set to nosniff. See Content Type Options for more information.
 * @property frameOptions Setting that determines whether CloudFront includes the X-Frame-Options HTTP response header and the header’s value. See Frame Options for more information.
 * @property referrerPolicies Value of the Referrer-Policy HTTP response header. Valid Values: `no-referrer` | `no-referrer-when-downgrade` | `origin` | `origin-when-cross-origin` | `same-origin` | `strict-origin` | `strict-origin-when-cross-origin` | `unsafe-url`
 * @property strictTransportSecurities Settings that determine whether CloudFront includes the Strict-Transport-Security HTTP response header and the header’s value. See Strict Transport Security for more information.
 * @property xssProtections Settings that determine whether CloudFront includes the X-XSS-Protection HTTP response header and the header’s value. See XSS Protection for more information.
 */
public data class GetResponseHeadersPolicySecurityHeadersConfig(
    public val contentSecurityPolicies: List<GetResponseHeadersPolicySecurityHeadersConfigContentSecurityPolicy>,
    public val contentTypeOptions: List<GetResponseHeadersPolicySecurityHeadersConfigContentTypeOption>,
    public val frameOptions: List<GetResponseHeadersPolicySecurityHeadersConfigFrameOption>,
    public val referrerPolicies: List<GetResponseHeadersPolicySecurityHeadersConfigReferrerPolicy>,
    public val strictTransportSecurities: List<GetResponseHeadersPolicySecurityHeadersConfigStrictTransportSecurity>,
    public val xssProtections: List<GetResponseHeadersPolicySecurityHeadersConfigXssProtection>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.GetResponseHeadersPolicySecurityHeadersConfig): GetResponseHeadersPolicySecurityHeadersConfig =
            GetResponseHeadersPolicySecurityHeadersConfig(
                contentSecurityPolicies = javaType.contentSecurityPolicies().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cloudfront.kotlin.outputs.GetResponseHeadersPolicySecurityHeadersConfigContentSecurityPolicy.Companion.toKotlin(args0)
                    })
                }),
                contentTypeOptions = javaType.contentTypeOptions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cloudfront.kotlin.outputs.GetResponseHeadersPolicySecurityHeadersConfigContentTypeOption.Companion.toKotlin(args0)
                    })
                }),
                frameOptions = javaType.frameOptions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cloudfront.kotlin.outputs.GetResponseHeadersPolicySecurityHeadersConfigFrameOption.Companion.toKotlin(args0)
                    })
                }),
                referrerPolicies = javaType.referrerPolicies().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cloudfront.kotlin.outputs.GetResponseHeadersPolicySecurityHeadersConfigReferrerPolicy.Companion.toKotlin(args0)
                    })
                }),
                strictTransportSecurities = javaType.strictTransportSecurities().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cloudfront.kotlin.outputs.GetResponseHeadersPolicySecurityHeadersConfigStrictTransportSecurity.Companion.toKotlin(args0)
                    })
                }),
                xssProtections = javaType.xssProtections().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cloudfront.kotlin.outputs.GetResponseHeadersPolicySecurityHeadersConfigXssProtection.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
