@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property frameOption Value of the X-Frame-Options HTTP response header. Valid values: `DENY` | `SAMEORIGIN`
 * @property override Whether CloudFront overrides the X-XSS-Protection HTTP response header received from the origin with the one specified in this response headers policy.
 */
public data class GetResponseHeadersPolicySecurityHeadersConfigFrameOption(
    public val frameOption: String,
    public val `override`: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.GetResponseHeadersPolicySecurityHeadersConfigFrameOption): GetResponseHeadersPolicySecurityHeadersConfigFrameOption =
            GetResponseHeadersPolicySecurityHeadersConfigFrameOption(
                frameOption = javaType.frameOption(),
                `override` = javaType.`override`(),
            )
    }
}
