@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property modeBlock Whether CloudFront includes the mode=block directive in the X-XSS-Protection header.
 * @property override Whether CloudFront overrides the X-XSS-Protection HTTP response header received from the origin with the one specified in this response headers policy.
 * @property protection Boolean value that determines the value of the X-XSS-Protection HTTP response header. When this setting is true, the value of the X-XSS-Protection header is 1. When this setting is false, the value of the X-XSS-Protection header is 0.
 * @property reportUri Whether CloudFront sets a reporting URI in the X-XSS-Protection header.
 */
public data class GetResponseHeadersPolicySecurityHeadersConfigXssProtection(
    public val modeBlock: Boolean,
    public val `override`: Boolean,
    public val protection: Boolean,
    public val reportUri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.GetResponseHeadersPolicySecurityHeadersConfigXssProtection): GetResponseHeadersPolicySecurityHeadersConfigXssProtection =
            GetResponseHeadersPolicySecurityHeadersConfigXssProtection(
                modeBlock = javaType.modeBlock(),
                `override` = javaType.`override`(),
                protection = javaType.protection(),
                reportUri = javaType.reportUri(),
            )
    }
}
