@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Suppress

/**
 *
 * @property enabled Whether CloudFront adds the `Server-Timing` header to HTTP responses that it sends in response to requests that match a cache behavior that's associated with this response headers policy.
 * @property samplingRate Number 0–100 (inclusive) that specifies the percentage of responses that you want CloudFront to add the Server-Timing header to.
 */
public data class GetResponseHeadersPolicyServerTimingHeadersConfig(
    public val enabled: Boolean,
    public val samplingRate: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.GetResponseHeadersPolicyServerTimingHeadersConfig): GetResponseHeadersPolicyServerTimingHeadersConfig =
            GetResponseHeadersPolicyServerTimingHeadersConfig(
                enabled = javaType.enabled(),
                samplingRate = javaType.samplingRate(),
            )
    }
}
