@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kinesisStreamConfig The Amazon Kinesis data stream configuration.
 * @property streamType The type of data stream where real-time log data is sent. The only valid value is `Kinesis`.
 */
public data class RealtimeLogConfigEndpoint(
    public val kinesisStreamConfig: RealtimeLogConfigEndpointKinesisStreamConfig,
    public val streamType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.RealtimeLogConfigEndpoint): RealtimeLogConfigEndpoint = RealtimeLogConfigEndpoint(
            kinesisStreamConfig = javaType.kinesisStreamConfig().let({ args0 ->
                com.pulumi.aws.cloudfront.kotlin.outputs.RealtimeLogConfigEndpointKinesisStreamConfig.Companion.toKotlin(args0)
            }),
            streamType = javaType.streamType(),
        )
    }
}
