@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property accessControlAllowCredentials A Boolean value that CloudFront uses as the value for the `Access-Control-Allow-Credentials` HTTP response header.
 * @property accessControlAllowHeaders Object that contains an attribute `items` that contains a list of HTTP header names that CloudFront includes as values for the `Access-Control-Allow-Headers` HTTP response header.
 * @property accessControlAllowMethods Object that contains an attribute `items` that contains a list of HTTP methods that CloudFront includes as values for the `Access-Control-Allow-Methods` HTTP response header. Valid values: `GET` | `POST` | `OPTIONS` | `PUT` | `DELETE` | `HEAD` | `ALL`
 * @property accessControlAllowOrigins Object that contains an attribute `items` that contains a list of origins that CloudFront can use as the value for the `Access-Control-Allow-Origin` HTTP response header.
 * @property accessControlExposeHeaders Object that contains an attribute `items` that contains a list of HTTP headers that CloudFront includes as values for the `Access-Control-Expose-Headers` HTTP response header.
 * @property accessControlMaxAgeSec A number that CloudFront uses as the value for the `Access-Control-Max-Age` HTTP response header.
 * @property originOverride A Boolean value that determines how CloudFront behaves for the HTTP response header.
 */
public data class ResponseHeadersPolicyCorsConfig(
    public val accessControlAllowCredentials: Boolean,
    public val accessControlAllowHeaders: ResponseHeadersPolicyCorsConfigAccessControlAllowHeaders,
    public val accessControlAllowMethods: ResponseHeadersPolicyCorsConfigAccessControlAllowMethods,
    public val accessControlAllowOrigins: ResponseHeadersPolicyCorsConfigAccessControlAllowOrigins,
    public val accessControlExposeHeaders: ResponseHeadersPolicyCorsConfigAccessControlExposeHeaders? =
        null,
    public val accessControlMaxAgeSec: Int? = null,
    public val originOverride: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.ResponseHeadersPolicyCorsConfig): ResponseHeadersPolicyCorsConfig = ResponseHeadersPolicyCorsConfig(
            accessControlAllowCredentials = javaType.accessControlAllowCredentials(),
            accessControlAllowHeaders = javaType.accessControlAllowHeaders().let({ args0 ->
                com.pulumi.aws.cloudfront.kotlin.outputs.ResponseHeadersPolicyCorsConfigAccessControlAllowHeaders.Companion.toKotlin(args0)
            }),
            accessControlAllowMethods = javaType.accessControlAllowMethods().let({ args0 ->
                com.pulumi.aws.cloudfront.kotlin.outputs.ResponseHeadersPolicyCorsConfigAccessControlAllowMethods.Companion.toKotlin(args0)
            }),
            accessControlAllowOrigins = javaType.accessControlAllowOrigins().let({ args0 ->
                com.pulumi.aws.cloudfront.kotlin.outputs.ResponseHeadersPolicyCorsConfigAccessControlAllowOrigins.Companion.toKotlin(args0)
            }),
            accessControlExposeHeaders = javaType.accessControlExposeHeaders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.ResponseHeadersPolicyCorsConfigAccessControlExposeHeaders.Companion.toKotlin(args0)
                })
            }).orElse(null),
            accessControlMaxAgeSec = javaType.accessControlMaxAgeSec().map({ args0 -> args0 }).orElse(null),
            originOverride = javaType.originOverride(),
        )
    }
}
