@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property accessControlMaxAgeSec A number that CloudFront uses as the value for the `max-age` directive in the `Strict-Transport-Security` HTTP response header.
 * @property includeSubdomains Whether CloudFront includes the `includeSubDomains` directive in the `Strict-Transport-Security` HTTP response header.
 * @property override Whether CloudFront overrides the `Strict-Transport-Security` HTTP response header received from the origin with the one specified in this response headers policy.
 * @property preload Whether CloudFront includes the `preload` directive in the `Strict-Transport-Security` HTTP response header.
 */
public data class ResponseHeadersPolicySecurityHeadersConfigStrictTransportSecurity(
    public val accessControlMaxAgeSec: Int,
    public val includeSubdomains: Boolean? = null,
    public val `override`: Boolean,
    public val preload: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.ResponseHeadersPolicySecurityHeadersConfigStrictTransportSecurity): ResponseHeadersPolicySecurityHeadersConfigStrictTransportSecurity =
            ResponseHeadersPolicySecurityHeadersConfigStrictTransportSecurity(
                accessControlMaxAgeSec = javaType.accessControlMaxAgeSec(),
                includeSubdomains = javaType.includeSubdomains().map({ args0 -> args0 }).orElse(null),
                `override` = javaType.`override`(),
                preload = javaType.preload().map({ args0 -> args0 }).orElse(null),
            )
    }
}
