@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property modeBlock Whether CloudFront includes the `mode=block` directive in the `X-XSS-Protection` header.
 * @property override Whether CloudFront overrides the `X-XSS-Protection` HTTP response header received from the origin with the one specified in this response headers policy.
 * @property protection A Boolean value that determines the value of the `X-XSS-Protection` HTTP response header. When this setting is `true`, the value of the `X-XSS-Protection` header is `1`. When this setting is `false`, the value of the `X-XSS-Protection` header is `0`.
 * @property reportUri A reporting URI, which CloudFront uses as the value of the report directive in the `X-XSS-Protection` header. You cannot specify a `report_uri` when `mode_block` is `true`.
 */
public data class ResponseHeadersPolicySecurityHeadersConfigXssProtection(
    public val modeBlock: Boolean? = null,
    public val `override`: Boolean,
    public val protection: Boolean,
    public val reportUri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.ResponseHeadersPolicySecurityHeadersConfigXssProtection): ResponseHeadersPolicySecurityHeadersConfigXssProtection =
            ResponseHeadersPolicySecurityHeadersConfigXssProtection(
                modeBlock = javaType.modeBlock().map({ args0 -> args0 }).orElse(null),
                `override` = javaType.`override`(),
                protection = javaType.protection(),
                reportUri = javaType.reportUri().map({ args0 -> args0 }).orElse(null),
            )
    }
}
