@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Suppress

/**
 *
 * @property enabled A Whether CloudFront adds the `Server-Timing` header to HTTP responses that it sends in response to requests that match a cache behavior that's associated with this response headers policy.
 * @property samplingRate A number 0–100 (inclusive) that specifies the percentage of responses that you want CloudFront to add the Server-Timing header to. Valid range: Minimum value of 0.0. Maximum value of 100.0.
 */
public data class ResponseHeadersPolicyServerTimingHeadersConfig(
    public val enabled: Boolean,
    public val samplingRate: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.ResponseHeadersPolicyServerTimingHeadersConfig): ResponseHeadersPolicyServerTimingHeadersConfig =
            ResponseHeadersPolicyServerTimingHeadersConfig(
                enabled = javaType.enabled(),
                samplingRate = javaType.samplingRate(),
            )
    }
}
