@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudhsmv2.kotlin

import com.pulumi.aws.cloudhsmv2.kotlin.outputs.ClusterClusterCertificate
import com.pulumi.aws.cloudhsmv2.kotlin.outputs.ClusterClusterCertificate.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Cluster].
 */
@PulumiTagMarker
public class ClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterArgs = ClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterArgsBuilder.() -> Unit) {
        val builder = ClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Cluster {
        val builtJavaResource = com.pulumi.aws.cloudhsmv2.Cluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cluster(builtJavaResource)
    }
}

/**
 * Creates an Amazon CloudHSM v2 cluster.
 * For information about CloudHSM v2, see the
 * [AWS CloudHSM User Guide](https://docs.aws.amazon.com/cloudhsm/latest/userguide/introduction.html) and the [Amazon
 * CloudHSM API Reference][2].
 * > **NOTE:** A CloudHSM Cluster can take several minutes to set up.
 * Practically no single attribute can be updated, except for `tags`.
 * If you need to delete a cluster, you have to remove its HSM modules first.
 * To initialize cluster, you have to add an HSM instance to the cluster, then sign CSR and upload it.
 * ## Import
 * Using `pulumi import`, import CloudHSM v2 Clusters using the cluster `id`. For example:
 * ```sh
 * $ pulumi import aws:cloudhsmv2/cluster:Cluster test_cluster cluster-aeb282a201
 * ```
 */
public class Cluster internal constructor(
    override val javaResource: com.pulumi.aws.cloudhsmv2.Cluster,
) : KotlinCustomResource(javaResource, ClusterMapper) {
    /**
     * The list of cluster certificates.
     */
    public val clusterCertificates: Output<List<ClusterClusterCertificate>>
        get() = javaResource.clusterCertificates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The id of the CloudHSM cluster.
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * The state of the CloudHSM cluster.
     */
    public val clusterState: Output<String>
        get() = javaResource.clusterState().applyValue({ args0 -> args0 })

    /**
     * The type of HSM module in the cluster. Currently, only `hsm1.medium` is supported.
     */
    public val hsmType: Output<String>
        get() = javaResource.hsmType().applyValue({ args0 -> args0 })

    /**
     * The ID of the security group associated with the CloudHSM cluster.
     */
    public val securityGroupId: Output<String>
        get() = javaResource.securityGroupId().applyValue({ args0 -> args0 })

    /**
     * ID of Cloud HSM v2 cluster backup to be restored.
     */
    public val sourceBackupIdentifier: Output<String>?
        get() = javaResource.sourceBackupIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IDs of subnets in which cluster will operate.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The id of the VPC that the CloudHSM cluster resides in.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object ClusterMapper : ResourceMapper<Cluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudhsmv2.Cluster::class == javaResource::class

    override fun map(javaResource: Resource): Cluster = Cluster(
        javaResource as
            com.pulumi.aws.cloudhsmv2.Cluster,
    )
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cluster].
 */
public suspend fun cluster(name: String, block: suspend ClusterResourceBuilder.() -> Unit): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cluster(name: String): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
