@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudhsmv2.kotlin

import com.pulumi.aws.cloudhsmv2.ClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates an Amazon CloudHSM v2 cluster.
 * For information about CloudHSM v2, see the
 * [AWS CloudHSM User Guide](https://docs.aws.amazon.com/cloudhsm/latest/userguide/introduction.html) and the [Amazon
 * CloudHSM API Reference][2].
 * > **NOTE:** A CloudHSM Cluster can take several minutes to set up.
 * Practically no single attribute can be updated, except for `tags`.
 * If you need to delete a cluster, you have to remove its HSM modules first.
 * To initialize cluster, you have to add an HSM instance to the cluster, then sign CSR and upload it.
 * ## Import
 * Using `pulumi import`, import CloudHSM v2 Clusters using the cluster `id`. For example:
 * ```sh
 * $ pulumi import aws:cloudhsmv2/cluster:Cluster test_cluster cluster-aeb282a201
 * ```
 * @property hsmType The type of HSM module in the cluster. Currently, only `hsm1.medium` is supported.
 * @property sourceBackupIdentifier ID of Cloud HSM v2 cluster backup to be restored.
 * @property subnetIds The IDs of subnets in which cluster will operate.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ClusterArgs(
    public val hsmType: Output<String>? = null,
    public val sourceBackupIdentifier: Output<String>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudhsmv2.ClusterArgs> {
    override fun toJava(): com.pulumi.aws.cloudhsmv2.ClusterArgs =
        com.pulumi.aws.cloudhsmv2.ClusterArgs.builder()
            .hsmType(hsmType?.applyValue({ args0 -> args0 }))
            .sourceBackupIdentifier(sourceBackupIdentifier?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var hsmType: Output<String>? = null

    private var sourceBackupIdentifier: Output<String>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The type of HSM module in the cluster. Currently, only `hsm1.medium` is supported.
     */
    @JvmName("wgfiknwkxfyhlgvm")
    public suspend fun hsmType(`value`: Output<String>) {
        this.hsmType = value
    }

    /**
     * @param value ID of Cloud HSM v2 cluster backup to be restored.
     */
    @JvmName("onopehjuueuyplge")
    public suspend fun sourceBackupIdentifier(`value`: Output<String>) {
        this.sourceBackupIdentifier = value
    }

    /**
     * @param value The IDs of subnets in which cluster will operate.
     */
    @JvmName("nixavhibxxhdlvrr")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("dtlivanifhgavwuw")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values The IDs of subnets in which cluster will operate.
     */
    @JvmName("rfwscqbyceashpwi")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rlgmnchuxfmwhyyd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of HSM module in the cluster. Currently, only `hsm1.medium` is supported.
     */
    @JvmName("etuwfrclekkclbgo")
    public suspend fun hsmType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hsmType = mapped
    }

    /**
     * @param value ID of Cloud HSM v2 cluster backup to be restored.
     */
    @JvmName("hryyfcowmisibmxq")
    public suspend fun sourceBackupIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceBackupIdentifier = mapped
    }

    /**
     * @param value The IDs of subnets in which cluster will operate.
     */
    @JvmName("stvoatxkoxvdpwls")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values The IDs of subnets in which cluster will operate.
     */
    @JvmName("xvrvjbmunppyeyxj")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fvuphbvjscokhtyh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bnacrmlhjvktcpdb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        hsmType = hsmType,
        sourceBackupIdentifier = sourceBackupIdentifier,
        subnetIds = subnetIds,
        tags = tags,
    )
}
