@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudhsmv2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Hsm].
 */
@PulumiTagMarker
public class HsmResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HsmArgs = HsmArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HsmArgsBuilder.() -> Unit) {
        val builder = HsmArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Hsm {
        val builtJavaResource = com.pulumi.aws.cloudhsmv2.Hsm(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Hsm(builtJavaResource)
    }
}

/**
 * Creates an HSM module in Amazon CloudHSM v2 cluster.
 * ## Example Usage
 * The following example below creates an HSM module in CloudHSM cluster.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const cluster = aws.cloudhsmv2.getCluster({
 *     clusterId: cloudhsmClusterId,
 * });
 * const cloudhsmV2Hsm = new aws.cloudhsmv2.Hsm("cloudhsm_v2_hsm", {
 *     subnetId: cluster.then(cluster => cluster.subnetIds?.[0]),
 *     clusterId: cluster.then(cluster => cluster.clusterId),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * cluster = aws.cloudhsmv2.get_cluster(cluster_id=cloudhsm_cluster_id)
 * cloudhsm_v2_hsm = aws.cloudhsmv2.Hsm("cloudhsm_v2_hsm",
 *     subnet_id=cluster.subnet_ids[0],
 *     cluster_id=cluster.cluster_id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = Aws.CloudHsmV2.GetCluster.Invoke(new()
 *     {
 *         ClusterId = cloudhsmClusterId,
 *     });
 *     var cloudhsmV2Hsm = new Aws.CloudHsmV2.Hsm("cloudhsm_v2_hsm", new()
 *     {
 *         SubnetId = cluster.Apply(getClusterResult => getClusterResult.SubnetIds[0]),
 *         ClusterId = cluster.Apply(getClusterResult => getClusterResult.ClusterId),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudhsmv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cluster, err := cloudhsmv2.LookupCluster(ctx, &cloudhsmv2.LookupClusterArgs{
 * 			ClusterId: cloudhsmClusterId,
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudhsmv2.NewHsm(ctx, "cloudhsm_v2_hsm", &cloudhsmv2.HsmArgs{
 * 			SubnetId:  pulumi.String(cluster.SubnetIds[0]),
 * 			ClusterId: pulumi.String(cluster.ClusterId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudhsmv2.Cloudhsmv2Functions;
 * import com.pulumi.aws.cloudhsmv2.inputs.GetClusterArgs;
 * import com.pulumi.aws.cloudhsmv2.Hsm;
 * import com.pulumi.aws.cloudhsmv2.HsmArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var cluster = Cloudhsmv2Functions.getCluster(GetClusterArgs.builder()
 *             .clusterId(cloudhsmClusterId)
 *             .build());
 *         var cloudhsmV2Hsm = new Hsm("cloudhsmV2Hsm", HsmArgs.builder()
 *             .subnetId(cluster.applyValue(getClusterResult -> getClusterResult.subnetIds()[0]))
 *             .clusterId(cluster.applyValue(getClusterResult -> getClusterResult.clusterId()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   cloudhsmV2Hsm:
 *     type: aws:cloudhsmv2:Hsm
 *     name: cloudhsm_v2_hsm
 *     properties:
 *       subnetId: ${cluster.subnetIds[0]}
 *       clusterId: ${cluster.clusterId}
 * variables:
 *   cluster:
 *     fn::invoke:
 *       Function: aws:cloudhsmv2:getCluster
 *       Arguments:
 *         clusterId: ${cloudhsmClusterId}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import HSM modules using their HSM ID. For example:
 * ```sh
 * $ pulumi import aws:cloudhsmv2/hsm:Hsm bar hsm-quo8dahtaca
 * ```
 */
public class Hsm internal constructor(
    override val javaResource: com.pulumi.aws.cloudhsmv2.Hsm,
) : KotlinCustomResource(javaResource, HsmMapper) {
    /**
     * The IDs of AZ in which HSM module will be located. Conflicts with `subnet_id`.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * The ID of Cloud HSM v2 cluster to which HSM will be added.
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * The id of the ENI interface allocated for HSM module.
     */
    public val hsmEniId: Output<String>
        get() = javaResource.hsmEniId().applyValue({ args0 -> args0 })

    /**
     * The id of the HSM module.
     */
    public val hsmId: Output<String>
        get() = javaResource.hsmId().applyValue({ args0 -> args0 })

    /**
     * The state of the HSM module.
     */
    public val hsmState: Output<String>
        get() = javaResource.hsmState().applyValue({ args0 -> args0 })

    /**
     * The IP address of HSM module. Must be within the CIDR of selected subnet.
     */
    public val ipAddress: Output<String>
        get() = javaResource.ipAddress().applyValue({ args0 -> args0 })

    /**
     * The ID of subnet in which HSM module will be located. Conflicts with `availability_zone`.
     */
    public val subnetId: Output<String>
        get() = javaResource.subnetId().applyValue({ args0 -> args0 })
}

public object HsmMapper : ResourceMapper<Hsm> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudhsmv2.Hsm::class == javaResource::class

    override fun map(javaResource: Resource): Hsm = Hsm(javaResource as com.pulumi.aws.cloudhsmv2.Hsm)
}

/**
 * @see [Hsm].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Hsm].
 */
public suspend fun hsm(name: String, block: suspend HsmResourceBuilder.() -> Unit): Hsm {
    val builder = HsmResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Hsm].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hsm(name: String): Hsm {
    val builder = HsmResourceBuilder()
    builder.name(name)
    return builder.build()
}
