@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudhsmv2.kotlin.inputs

import com.pulumi.aws.cloudhsmv2.inputs.GetClusterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCluster.
 * @property clusterId ID of Cloud HSM v2 cluster.
 * @property clusterState State of the cluster to be found.
 */
public data class GetClusterPlainArgs(
    public val clusterId: String,
    public val clusterState: String? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudhsmv2.inputs.GetClusterPlainArgs> {
    override fun toJava(): com.pulumi.aws.cloudhsmv2.inputs.GetClusterPlainArgs =
        com.pulumi.aws.cloudhsmv2.inputs.GetClusterPlainArgs.builder()
            .clusterId(clusterId.let({ args0 -> args0 }))
            .clusterState(clusterState?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetClusterPlainArgs].
 */
@PulumiTagMarker
public class GetClusterPlainArgsBuilder internal constructor() {
    private var clusterId: String? = null

    private var clusterState: String? = null

    /**
     * @param value ID of Cloud HSM v2 cluster.
     */
    @JvmName("yiugxvtuoyemjbvf")
    public suspend fun clusterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterId = mapped
    }

    /**
     * @param value State of the cluster to be found.
     */
    @JvmName("bghledntjvglsoon")
    public suspend fun clusterState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.clusterState = mapped
    }

    internal fun build(): GetClusterPlainArgs = GetClusterPlainArgs(
        clusterId = clusterId ?: throw PulumiNullFieldException("clusterId"),
        clusterState = clusterState,
    )
}
