@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudhsmv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property awsHardwareCertificate The HSM hardware certificate issued (signed) by AWS CloudHSM.
 * @property clusterCertificate The cluster certificate issued (signed) by the issuing certificate authority (CA) of the cluster's owner.
 * @property clusterCsr The certificate signing request (CSR). Available only in `UNINITIALIZED` state after an HSM instance is added to the cluster.
 * @property hsmCertificate The HSM certificate issued (signed) by the HSM hardware.
 * @property manufacturerHardwareCertificate The HSM hardware certificate issued (signed) by the hardware manufacturer.
 */
public data class ClusterClusterCertificate(
    public val awsHardwareCertificate: String? = null,
    public val clusterCertificate: String? = null,
    public val clusterCsr: String? = null,
    public val hsmCertificate: String? = null,
    public val manufacturerHardwareCertificate: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudhsmv2.outputs.ClusterClusterCertificate): ClusterClusterCertificate = ClusterClusterCertificate(
            awsHardwareCertificate = javaType.awsHardwareCertificate().map({ args0 -> args0 }).orElse(null),
            clusterCertificate = javaType.clusterCertificate().map({ args0 -> args0 }).orElse(null),
            clusterCsr = javaType.clusterCsr().map({ args0 -> args0 }).orElse(null),
            hsmCertificate = javaType.hsmCertificate().map({ args0 -> args0 }).orElse(null),
            manufacturerHardwareCertificate = javaType.manufacturerHardwareCertificate().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
