@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudhsmv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property awsHardwareCertificate The HSM hardware certificate issued (signed) by AWS CloudHSM.
 * @property clusterCertificate The cluster certificate issued (signed) by the issuing certificate authority (CA) of the cluster's owner.
 * @property clusterCsr The certificate signing request (CSR). Available only in UNINITIALIZED state.
 * @property hsmCertificate The HSM certificate issued (signed) by the HSM hardware.
 * @property manufacturerHardwareCertificate The HSM hardware certificate issued (signed) by the hardware manufacturer.
 * The number of available cluster certificates may vary depending on state of the cluster.
 */
public data class GetClusterClusterCertificate(
    public val awsHardwareCertificate: String,
    public val clusterCertificate: String,
    public val clusterCsr: String,
    public val hsmCertificate: String,
    public val manufacturerHardwareCertificate: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudhsmv2.outputs.GetClusterClusterCertificate): GetClusterClusterCertificate = GetClusterClusterCertificate(
            awsHardwareCertificate = javaType.awsHardwareCertificate(),
            clusterCertificate = javaType.clusterCertificate(),
            clusterCsr = javaType.clusterCsr(),
            hsmCertificate = javaType.hsmCertificate(),
            manufacturerHardwareCertificate = javaType.manufacturerHardwareCertificate(),
        )
    }
}
