@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudsearch.kotlin

import com.pulumi.aws.cloudsearch.kotlin.outputs.DomainEndpointOptions
import com.pulumi.aws.cloudsearch.kotlin.outputs.DomainIndexField
import com.pulumi.aws.cloudsearch.kotlin.outputs.DomainScalingParameters
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.cloudsearch.kotlin.outputs.DomainEndpointOptions.Companion.toKotlin as domainEndpointOptionsToKotlin
import com.pulumi.aws.cloudsearch.kotlin.outputs.DomainIndexField.Companion.toKotlin as domainIndexFieldToKotlin
import com.pulumi.aws.cloudsearch.kotlin.outputs.DomainScalingParameters.Companion.toKotlin as domainScalingParametersToKotlin

/**
 * Builder for [Domain].
 */
@PulumiTagMarker
public class DomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainArgs = DomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainArgsBuilder.() -> Unit) {
        val builder = DomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Domain {
        val builtJavaResource = com.pulumi.aws.cloudsearch.Domain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Domain(builtJavaResource)
    }
}

/**
 * Provides an CloudSearch domain resource.
 * The provider waits for the domain to become `Active` when applying a configuration.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudsearch.Domain("example", {
 *     name: "example-domain",
 *     scalingParameters: {
 *         desiredInstanceType: "search.medium",
 *     },
 *     indexFields: [
 *         {
 *             name: "headline",
 *             type: "text",
 *             search: true,
 *             "return": true,
 *             sort: true,
 *             highlight: false,
 *             analysisScheme: "_en_default_",
 *         },
 *         {
 *             name: "price",
 *             type: "double",
 *             search: true,
 *             facet: true,
 *             "return": true,
 *             sort: true,
 *             sourceFields: "headline",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudsearch.Domain("example",
 *     name="example-domain",
 *     scaling_parameters={
 *         "desired_instance_type": "search.medium",
 *     },
 *     index_fields=[
 *         {
 *             "name": "headline",
 *             "type": "text",
 *             "search": True,
 *             "return_": True,
 *             "sort": True,
 *             "highlight": False,
 *             "analysis_scheme": "_en_default_",
 *         },
 *         {
 *             "name": "price",
 *             "type": "double",
 *             "search": True,
 *             "facet": True,
 *             "return_": True,
 *             "sort": True,
 *             "source_fields": "headline",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudSearch.Domain("example", new()
 *     {
 *         Name = "example-domain",
 *         ScalingParameters = new Aws.CloudSearch.Inputs.DomainScalingParametersArgs
 *         {
 *             DesiredInstanceType = "search.medium",
 *         },
 *         IndexFields = new[]
 *         {
 *             new Aws.CloudSearch.Inputs.DomainIndexFieldArgs
 *             {
 *                 Name = "headline",
 *                 Type = "text",
 *                 Search = true,
 *                 Return = true,
 *                 Sort = true,
 *                 Highlight = false,
 *                 AnalysisScheme = "_en_default_",
 *             },
 *             new Aws.CloudSearch.Inputs.DomainIndexFieldArgs
 *             {
 *                 Name = "price",
 *                 Type = "double",
 *                 Search = true,
 *                 Facet = true,
 *                 Return = true,
 *                 Sort = true,
 *                 SourceFields = "headline",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudsearch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudsearch.NewDomain(ctx, "example", &cloudsearch.DomainArgs{
 * 			Name: pulumi.String("example-domain"),
 * 			ScalingParameters: &cloudsearch.DomainScalingParametersArgs{
 * 				DesiredInstanceType: pulumi.String("search.medium"),
 * 			},
 * 			IndexFields: cloudsearch.DomainIndexFieldArray{
 * 				&cloudsearch.DomainIndexFieldArgs{
 * 					Name:           pulumi.String("headline"),
 * 					Type:           pulumi.String("text"),
 * 					Search:         pulumi.Bool(true),
 * 					Return:         pulumi.Bool(true),
 * 					Sort:           pulumi.Bool(true),
 * 					Highlight:      pulumi.Bool(false),
 * 					AnalysisScheme: pulumi.String("_en_default_"),
 * 				},
 * 				&cloudsearch.DomainIndexFieldArgs{
 * 					Name:         pulumi.String("price"),
 * 					Type:         pulumi.String("double"),
 * 					Search:       pulumi.Bool(true),
 * 					Facet:        pulumi.Bool(true),
 * 					Return:       pulumi.Bool(true),
 * 					Sort:         pulumi.Bool(true),
 * 					SourceFields: pulumi.String("headline"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudsearch.Domain;
 * import com.pulumi.aws.cloudsearch.DomainArgs;
 * import com.pulumi.aws.cloudsearch.inputs.DomainScalingParametersArgs;
 * import com.pulumi.aws.cloudsearch.inputs.DomainIndexFieldArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .name("example-domain")
 *             .scalingParameters(DomainScalingParametersArgs.builder()
 *                 .desiredInstanceType("search.medium")
 *                 .build())
 *             .indexFields(
 *                 DomainIndexFieldArgs.builder()
 *                     .name("headline")
 *                     .type("text")
 *                     .search(true)
 *                     .return_(true)
 *                     .sort(true)
 *                     .highlight(false)
 *                     .analysisScheme("_en_default_")
 *                     .build(),
 *                 DomainIndexFieldArgs.builder()
 *                     .name("price")
 *                     .type("double")
 *                     .search(true)
 *                     .facet(true)
 *                     .return_(true)
 *                     .sort(true)
 *                     .sourceFields("headline")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudsearch:Domain
 *     properties:
 *       name: example-domain
 *       scalingParameters:
 *         desiredInstanceType: search.medium
 *       indexFields:
 *         - name: headline
 *           type: text
 *           search: true
 *           return: true
 *           sort: true
 *           highlight: false
 *           analysisScheme: _en_default_
 *         - name: price
 *           type: double
 *           search: true
 *           facet: true
 *           return: true
 *           sort: true
 *           sourceFields: headline
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudSearch Domains using the `name`. For example:
 * ```sh
 * $ pulumi import aws:cloudsearch/domain:Domain example example-domain
 * ```
 */
public class Domain internal constructor(
    override val javaResource: com.pulumi.aws.cloudsearch.Domain,
) : KotlinCustomResource(javaResource, DomainMapper) {
    /**
     * The domain's ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The service endpoint for updating documents in a search domain.
     */
    public val documentServiceEndpoint: Output<String>
        get() = javaResource.documentServiceEndpoint().applyValue({ args0 -> args0 })

    /**
     * An internally generated unique identifier for the domain.
     */
    public val domainId: Output<String>
        get() = javaResource.domainId().applyValue({ args0 -> args0 })

    /**
     * Domain endpoint options. Documented below.
     */
    public val endpointOptions: Output<DomainEndpointOptions>
        get() = javaResource.endpointOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                domainEndpointOptionsToKotlin(args0)
            })
        })

    /**
     * The index fields for documents added to the domain. Documented below.
     */
    public val indexFields: Output<List<DomainIndexField>>?
        get() = javaResource.indexFields().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> domainIndexFieldToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Whether or not to maintain extra instances for the domain in a second Availability Zone to ensure high availability.
     */
    public val multiAz: Output<Boolean>
        get() = javaResource.multiAz().applyValue({ args0 -> args0 })

    /**
     * The name of the CloudSearch domain.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Domain scaling parameters. Documented below.
     */
    public val scalingParameters: Output<DomainScalingParameters>
        get() = javaResource.scalingParameters().applyValue({ args0 ->
            args0.let({ args0 ->
                domainScalingParametersToKotlin(args0)
            })
        })

    /**
     * The service endpoint for requesting search results from a search domain.
     */
    public val searchServiceEndpoint: Output<String>
        get() = javaResource.searchServiceEndpoint().applyValue({ args0 -> args0 })
}

public object DomainMapper : ResourceMapper<Domain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudsearch.Domain::class == javaResource::class

    override fun map(javaResource: Resource): Domain = Domain(
        javaResource as
            com.pulumi.aws.cloudsearch.Domain,
    )
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Domain].
 */
public suspend fun domain(name: String, block: suspend DomainResourceBuilder.() -> Unit): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domain(name: String): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
