@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudsearch.kotlin

import com.pulumi.aws.cloudsearch.DomainArgs.builder
import com.pulumi.aws.cloudsearch.kotlin.inputs.DomainEndpointOptionsArgs
import com.pulumi.aws.cloudsearch.kotlin.inputs.DomainEndpointOptionsArgsBuilder
import com.pulumi.aws.cloudsearch.kotlin.inputs.DomainIndexFieldArgs
import com.pulumi.aws.cloudsearch.kotlin.inputs.DomainIndexFieldArgsBuilder
import com.pulumi.aws.cloudsearch.kotlin.inputs.DomainScalingParametersArgs
import com.pulumi.aws.cloudsearch.kotlin.inputs.DomainScalingParametersArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an CloudSearch domain resource.
 * The provider waits for the domain to become `Active` when applying a configuration.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudsearch.Domain("example", {
 *     name: "example-domain",
 *     scalingParameters: {
 *         desiredInstanceType: "search.medium",
 *     },
 *     indexFields: [
 *         {
 *             name: "headline",
 *             type: "text",
 *             search: true,
 *             "return": true,
 *             sort: true,
 *             highlight: false,
 *             analysisScheme: "_en_default_",
 *         },
 *         {
 *             name: "price",
 *             type: "double",
 *             search: true,
 *             facet: true,
 *             "return": true,
 *             sort: true,
 *             sourceFields: "headline",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudsearch.Domain("example",
 *     name="example-domain",
 *     scaling_parameters={
 *         "desired_instance_type": "search.medium",
 *     },
 *     index_fields=[
 *         {
 *             "name": "headline",
 *             "type": "text",
 *             "search": True,
 *             "return_": True,
 *             "sort": True,
 *             "highlight": False,
 *             "analysis_scheme": "_en_default_",
 *         },
 *         {
 *             "name": "price",
 *             "type": "double",
 *             "search": True,
 *             "facet": True,
 *             "return_": True,
 *             "sort": True,
 *             "source_fields": "headline",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudSearch.Domain("example", new()
 *     {
 *         Name = "example-domain",
 *         ScalingParameters = new Aws.CloudSearch.Inputs.DomainScalingParametersArgs
 *         {
 *             DesiredInstanceType = "search.medium",
 *         },
 *         IndexFields = new[]
 *         {
 *             new Aws.CloudSearch.Inputs.DomainIndexFieldArgs
 *             {
 *                 Name = "headline",
 *                 Type = "text",
 *                 Search = true,
 *                 Return = true,
 *                 Sort = true,
 *                 Highlight = false,
 *                 AnalysisScheme = "_en_default_",
 *             },
 *             new Aws.CloudSearch.Inputs.DomainIndexFieldArgs
 *             {
 *                 Name = "price",
 *                 Type = "double",
 *                 Search = true,
 *                 Facet = true,
 *                 Return = true,
 *                 Sort = true,
 *                 SourceFields = "headline",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudsearch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudsearch.NewDomain(ctx, "example", &cloudsearch.DomainArgs{
 * 			Name: pulumi.String("example-domain"),
 * 			ScalingParameters: &cloudsearch.DomainScalingParametersArgs{
 * 				DesiredInstanceType: pulumi.String("search.medium"),
 * 			},
 * 			IndexFields: cloudsearch.DomainIndexFieldArray{
 * 				&cloudsearch.DomainIndexFieldArgs{
 * 					Name:           pulumi.String("headline"),
 * 					Type:           pulumi.String("text"),
 * 					Search:         pulumi.Bool(true),
 * 					Return:         pulumi.Bool(true),
 * 					Sort:           pulumi.Bool(true),
 * 					Highlight:      pulumi.Bool(false),
 * 					AnalysisScheme: pulumi.String("_en_default_"),
 * 				},
 * 				&cloudsearch.DomainIndexFieldArgs{
 * 					Name:         pulumi.String("price"),
 * 					Type:         pulumi.String("double"),
 * 					Search:       pulumi.Bool(true),
 * 					Facet:        pulumi.Bool(true),
 * 					Return:       pulumi.Bool(true),
 * 					Sort:         pulumi.Bool(true),
 * 					SourceFields: pulumi.String("headline"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudsearch.Domain;
 * import com.pulumi.aws.cloudsearch.DomainArgs;
 * import com.pulumi.aws.cloudsearch.inputs.DomainScalingParametersArgs;
 * import com.pulumi.aws.cloudsearch.inputs.DomainIndexFieldArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .name("example-domain")
 *             .scalingParameters(DomainScalingParametersArgs.builder()
 *                 .desiredInstanceType("search.medium")
 *                 .build())
 *             .indexFields(
 *                 DomainIndexFieldArgs.builder()
 *                     .name("headline")
 *                     .type("text")
 *                     .search(true)
 *                     .return_(true)
 *                     .sort(true)
 *                     .highlight(false)
 *                     .analysisScheme("_en_default_")
 *                     .build(),
 *                 DomainIndexFieldArgs.builder()
 *                     .name("price")
 *                     .type("double")
 *                     .search(true)
 *                     .facet(true)
 *                     .return_(true)
 *                     .sort(true)
 *                     .sourceFields("headline")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudsearch:Domain
 *     properties:
 *       name: example-domain
 *       scalingParameters:
 *         desiredInstanceType: search.medium
 *       indexFields:
 *         - name: headline
 *           type: text
 *           search: true
 *           return: true
 *           sort: true
 *           highlight: false
 *           analysisScheme: _en_default_
 *         - name: price
 *           type: double
 *           search: true
 *           facet: true
 *           return: true
 *           sort: true
 *           sourceFields: headline
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudSearch Domains using the `name`. For example:
 * ```sh
 * $ pulumi import aws:cloudsearch/domain:Domain example example-domain
 * ```
 * @property endpointOptions Domain endpoint options. Documented below.
 * @property indexFields The index fields for documents added to the domain. Documented below.
 * @property multiAz Whether or not to maintain extra instances for the domain in a second Availability Zone to ensure high availability.
 * @property name The name of the CloudSearch domain.
 * @property scalingParameters Domain scaling parameters. Documented below.
 */
public data class DomainArgs(
    public val endpointOptions: Output<DomainEndpointOptionsArgs>? = null,
    public val indexFields: Output<List<DomainIndexFieldArgs>>? = null,
    public val multiAz: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val scalingParameters: Output<DomainScalingParametersArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudsearch.DomainArgs> {
    override fun toJava(): com.pulumi.aws.cloudsearch.DomainArgs =
        com.pulumi.aws.cloudsearch.DomainArgs.builder()
            .endpointOptions(endpointOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .indexFields(
                indexFields?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .multiAz(multiAz?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .scalingParameters(
                scalingParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DomainArgs].
 */
@PulumiTagMarker
public class DomainArgsBuilder internal constructor() {
    private var endpointOptions: Output<DomainEndpointOptionsArgs>? = null

    private var indexFields: Output<List<DomainIndexFieldArgs>>? = null

    private var multiAz: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var scalingParameters: Output<DomainScalingParametersArgs>? = null

    /**
     * @param value Domain endpoint options. Documented below.
     */
    @JvmName("opsxlfjgeyfvxvif")
    public suspend fun endpointOptions(`value`: Output<DomainEndpointOptionsArgs>) {
        this.endpointOptions = value
    }

    /**
     * @param value The index fields for documents added to the domain. Documented below.
     */
    @JvmName("vhtvyejipgwnqhst")
    public suspend fun indexFields(`value`: Output<List<DomainIndexFieldArgs>>) {
        this.indexFields = value
    }

    @JvmName("oofwqbqjquybxlhx")
    public suspend fun indexFields(vararg values: Output<DomainIndexFieldArgs>) {
        this.indexFields = Output.all(values.asList())
    }

    /**
     * @param values The index fields for documents added to the domain. Documented below.
     */
    @JvmName("pjgxfnagyswsoimg")
    public suspend fun indexFields(values: List<Output<DomainIndexFieldArgs>>) {
        this.indexFields = Output.all(values)
    }

    /**
     * @param value Whether or not to maintain extra instances for the domain in a second Availability Zone to ensure high availability.
     */
    @JvmName("uvpmjncqhjptmdws")
    public suspend fun multiAz(`value`: Output<Boolean>) {
        this.multiAz = value
    }

    /**
     * @param value The name of the CloudSearch domain.
     */
    @JvmName("hruelokkessdaxvi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Domain scaling parameters. Documented below.
     */
    @JvmName("uikxbjgycpvtatto")
    public suspend fun scalingParameters(`value`: Output<DomainScalingParametersArgs>) {
        this.scalingParameters = value
    }

    /**
     * @param value Domain endpoint options. Documented below.
     */
    @JvmName("aosgkjitihhltcww")
    public suspend fun endpointOptions(`value`: DomainEndpointOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointOptions = mapped
    }

    /**
     * @param argument Domain endpoint options. Documented below.
     */
    @JvmName("xnnhbemwadqncjph")
    public suspend fun endpointOptions(argument: suspend DomainEndpointOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainEndpointOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.endpointOptions = mapped
    }

    /**
     * @param value The index fields for documents added to the domain. Documented below.
     */
    @JvmName("rkbwqgkbolsjgeel")
    public suspend fun indexFields(`value`: List<DomainIndexFieldArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexFields = mapped
    }

    /**
     * @param argument The index fields for documents added to the domain. Documented below.
     */
    @JvmName("wlluwwykvsdwydue")
    public suspend fun indexFields(argument: List<suspend DomainIndexFieldArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainIndexFieldArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.indexFields = mapped
    }

    /**
     * @param argument The index fields for documents added to the domain. Documented below.
     */
    @JvmName("mtosttovrrikghxe")
    public suspend fun indexFields(vararg argument: suspend DomainIndexFieldArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainIndexFieldArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.indexFields = mapped
    }

    /**
     * @param argument The index fields for documents added to the domain. Documented below.
     */
    @JvmName("kfbipakrsheixygc")
    public suspend fun indexFields(argument: suspend DomainIndexFieldArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DomainIndexFieldArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.indexFields = mapped
    }

    /**
     * @param values The index fields for documents added to the domain. Documented below.
     */
    @JvmName("naulinvlphujswtf")
    public suspend fun indexFields(vararg values: DomainIndexFieldArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.indexFields = mapped
    }

    /**
     * @param value Whether or not to maintain extra instances for the domain in a second Availability Zone to ensure high availability.
     */
    @JvmName("byrqdvxygcportiy")
    public suspend fun multiAz(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiAz = mapped
    }

    /**
     * @param value The name of the CloudSearch domain.
     */
    @JvmName("qfbcyxhrglpljvdr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Domain scaling parameters. Documented below.
     */
    @JvmName("apjtcgokbdljsksa")
    public suspend fun scalingParameters(`value`: DomainScalingParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingParameters = mapped
    }

    /**
     * @param argument Domain scaling parameters. Documented below.
     */
    @JvmName("gcieltgibdqikyxq")
    public suspend fun scalingParameters(argument: suspend DomainScalingParametersArgsBuilder.() -> Unit) {
        val toBeMapped = DomainScalingParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scalingParameters = mapped
    }

    internal fun build(): DomainArgs = DomainArgs(
        endpointOptions = endpointOptions,
        indexFields = indexFields,
        multiAz = multiAz,
        name = name,
        scalingParameters = scalingParameters,
    )
}
