@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudsearch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DomainServiceAccessPolicy].
 */
@PulumiTagMarker
public class DomainServiceAccessPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainServiceAccessPolicyArgs = DomainServiceAccessPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainServiceAccessPolicyArgsBuilder.() -> Unit) {
        val builder = DomainServiceAccessPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DomainServiceAccessPolicy {
        val builtJavaResource =
            com.pulumi.aws.cloudsearch.DomainServiceAccessPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DomainServiceAccessPolicy(builtJavaResource)
    }
}

/**
 * Provides an CloudSearch domain service access policy resource.
 * The provider waits for the domain service access policy to become `Active` when applying a configuration.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleDomain = new aws.cloudsearch.Domain("example", {name: "example-domain"});
 * const example = aws.iam.getPolicyDocument({
 *     statements: [{
 *         sid: "search_only",
 *         effect: "Allow",
 *         principals: [{
 *             type: "*",
 *             identifiers: ["*"],
 *         }],
 *         actions: [
 *             "cloudsearch:search",
 *             "cloudsearch:document",
 *         ],
 *         conditions: [{
 *             test: "IpAddress",
 *             variable: "aws:SourceIp",
 *             values: ["192&#46;0&#46;2&#46;0/32"],
 *         }],
 *     }],
 * });
 * const exampleDomainServiceAccessPolicy = new aws.cloudsearch.DomainServiceAccessPolicy("example", {
 *     domainName: exampleDomain.id,
 *     accessPolicy: example.then(example => example.json),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_domain = aws.cloudsearch.Domain("example", name="example-domain")
 * example = aws.iam.get_policy_document(statements=[{
 *     "sid": "search_only",
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "*",
 *         "identifiers": ["*"],
 *     }],
 *     "actions": [
 *         "cloudsearch:search",
 *         "cloudsearch:document",
 *     ],
 *     "conditions": [{
 *         "test": "IpAddress",
 *         "variable": "aws:SourceIp",
 *         "values": ["192&#46;0&#46;2&#46;0/32"],
 *     }],
 * }])
 * example_domain_service_access_policy = aws.cloudsearch.DomainServiceAccessPolicy("example",
 *     domain_name=example_domain.id,
 *     access_policy=example.json)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleDomain = new Aws.CloudSearch.Domain("example", new()
 *     {
 *         Name = "example-domain",
 *     });
 *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Sid = "search_only",
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "*",
 *                         Identifiers = new[]
 *                         {
 *                             "*",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "cloudsearch:search",
 *                     "cloudsearch:document",
 *                 },
 *                 Conditions = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "IpAddress",
 *                         Variable = "aws:SourceIp",
 *                         Values = new[]
 *                         {
 *                             "192.0.2.0/32",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var exampleDomainServiceAccessPolicy = new Aws.CloudSearch.DomainServiceAccessPolicy("example", new()
 *     {
 *         DomainName = exampleDomain.Id,
 *         AccessPolicy = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudsearch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleDomain, err := cloudsearch.NewDomain(ctx, "example", &cloudsearch.DomainArgs{
 * 			Name: pulumi.String("example-domain"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Sid:    pulumi.StringRef("search_only"),
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "*",
 * 							Identifiers: []string{
 * 								"*",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"cloudsearch:search",
 * 						"cloudsearch:document",
 * 					},
 * 					Conditions: []iam.GetPolicyDocumentStatementCondition{
 * 						{
 * 							Test:     "IpAddress",
 * 							Variable: "aws:SourceIp",
 * 							Values: []string{
 * 								"192.0.2.0/32",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudsearch.NewDomainServiceAccessPolicy(ctx, "example", &cloudsearch.DomainServiceAccessPolicyArgs{
 * 			DomainName:   exampleDomain.ID(),
 * 			AccessPolicy: pulumi.String(example.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudsearch.Domain;
 * import com.pulumi.aws.cloudsearch.DomainArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudsearch.DomainServiceAccessPolicy;
 * import com.pulumi.aws.cloudsearch.DomainServiceAccessPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .name("example-domain")
 *             .build());
 *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("search_only")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("*")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions(
 *                     "cloudsearch:search",
 *                     "cloudsearch:document")
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("IpAddress")
 *                     .variable("aws:SourceIp")
 *                     .values("192.0.2.0/32")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleDomainServiceAccessPolicy = new DomainServiceAccessPolicy("exampleDomainServiceAccessPolicy", DomainServiceAccessPolicyArgs.builder()
 *             .domainName(exampleDomain.id())
 *             .accessPolicy(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleDomain:
 *     type: aws:cloudsearch:Domain
 *     name: example
 *     properties:
 *       name: example-domain
 *   exampleDomainServiceAccessPolicy:
 *     type: aws:cloudsearch:DomainServiceAccessPolicy
 *     name: example
 *     properties:
 *       domainName: ${exampleDomain.id}
 *       accessPolicy: ${example.json}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - sid: search_only
 *             effect: Allow
 *             principals:
 *               - type: '*'
 *                 identifiers:
 *                   - '*'
 *             actions:
 *               - cloudsearch:search
 *               - cloudsearch:document
 *             conditions:
 *               - test: IpAddress
 *                 variable: aws:SourceIp
 *                 values:
 *                   - 192.0.2.0/32
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudSearch domain service access policies using the domain name. For example:
 * ```sh
 * $ pulumi import aws:cloudsearch/domainServiceAccessPolicy:DomainServiceAccessPolicy example example-domain
 * ```
 */
public class DomainServiceAccessPolicy internal constructor(
    override val javaResource: com.pulumi.aws.cloudsearch.DomainServiceAccessPolicy,
) : KotlinCustomResource(javaResource, DomainServiceAccessPolicyMapper) {
    /**
     * The access rules you want to configure. These rules replace any existing rules. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html) for details.
     */
    public val accessPolicy: Output<String>
        get() = javaResource.accessPolicy().applyValue({ args0 -> args0 })

    /**
     * The CloudSearch domain name the policy applies to.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })
}

public object DomainServiceAccessPolicyMapper : ResourceMapper<DomainServiceAccessPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudsearch.DomainServiceAccessPolicy::class == javaResource::class

    override fun map(javaResource: Resource): DomainServiceAccessPolicy =
        DomainServiceAccessPolicy(
            javaResource as
                com.pulumi.aws.cloudsearch.DomainServiceAccessPolicy,
        )
}

/**
 * @see [DomainServiceAccessPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainServiceAccessPolicy].
 */
public suspend fun domainServiceAccessPolicy(
    name: String,
    block: suspend DomainServiceAccessPolicyResourceBuilder.() -> Unit,
): DomainServiceAccessPolicy {
    val builder = DomainServiceAccessPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainServiceAccessPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainServiceAccessPolicy(name: String): DomainServiceAccessPolicy {
    val builder = DomainServiceAccessPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
