@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudsearch.kotlin.inputs

import com.pulumi.aws.cloudsearch.inputs.DomainEndpointOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enforceHttps Enables or disables the requirement that all requests to the domain arrive over HTTPS.
 * @property tlsSecurityPolicy The minimum required TLS version. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DomainEndpointOptions.html) for valid values.
 */
public data class DomainEndpointOptionsArgs(
    public val enforceHttps: Output<Boolean>? = null,
    public val tlsSecurityPolicy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudsearch.inputs.DomainEndpointOptionsArgs> {
    override fun toJava(): com.pulumi.aws.cloudsearch.inputs.DomainEndpointOptionsArgs =
        com.pulumi.aws.cloudsearch.inputs.DomainEndpointOptionsArgs.builder()
            .enforceHttps(enforceHttps?.applyValue({ args0 -> args0 }))
            .tlsSecurityPolicy(tlsSecurityPolicy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainEndpointOptionsArgs].
 */
@PulumiTagMarker
public class DomainEndpointOptionsArgsBuilder internal constructor() {
    private var enforceHttps: Output<Boolean>? = null

    private var tlsSecurityPolicy: Output<String>? = null

    /**
     * @param value Enables or disables the requirement that all requests to the domain arrive over HTTPS.
     */
    @JvmName("iwcdhpppuqiqksvf")
    public suspend fun enforceHttps(`value`: Output<Boolean>) {
        this.enforceHttps = value
    }

    /**
     * @param value The minimum required TLS version. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DomainEndpointOptions.html) for valid values.
     */
    @JvmName("jlgflddbkgesoqro")
    public suspend fun tlsSecurityPolicy(`value`: Output<String>) {
        this.tlsSecurityPolicy = value
    }

    /**
     * @param value Enables or disables the requirement that all requests to the domain arrive over HTTPS.
     */
    @JvmName("qgeppjqycvjfqcoo")
    public suspend fun enforceHttps(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enforceHttps = mapped
    }

    /**
     * @param value The minimum required TLS version. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DomainEndpointOptions.html) for valid values.
     */
    @JvmName("yxwlhrgcvcgoxccn")
    public suspend fun tlsSecurityPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsSecurityPolicy = mapped
    }

    internal fun build(): DomainEndpointOptionsArgs = DomainEndpointOptionsArgs(
        enforceHttps = enforceHttps,
        tlsSecurityPolicy = tlsSecurityPolicy,
    )
}
