@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudsearch.kotlin.inputs

import com.pulumi.aws.cloudsearch.inputs.DomainIndexFieldArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property analysisScheme The analysis scheme you want to use for a `text` field. The analysis scheme specifies the language-specific text processing options that are used during indexing.
 * @property defaultValue The default value for the field. This value is used when no value is specified for the field in the document data.
 * @property facet You can get facet information by enabling this.
 * @property highlight You can highlight information.
 * @property name A unique name for the field. Field names must begin with a letter and be at least 1 and no more than 64 characters long. The allowed characters are: `a`-`z` (lower-case letters), `0`-`9`, and `_` (underscore). The name `score` is reserved and cannot be used as a field name.
 * @property return You can enable returning the value of all searchable fields.
 * @property search You can set whether this index should be searchable or not.
 * @property sort You can enable the property to be sortable.
 * @property sourceFields A comma-separated list of source fields to map to the field. Specifying a source field copies data from one field to another, enabling you to use the same source data in different ways by configuring different options for the fields.
 * @property type The field type. Valid values: `date`, `date-array`, `double`, `double-array`, `int`, `int-array`, `literal`, `literal-array`, `text`, `text-array`.
 */
public data class DomainIndexFieldArgs(
    public val analysisScheme: Output<String>? = null,
    public val defaultValue: Output<String>? = null,
    public val facet: Output<Boolean>? = null,
    public val highlight: Output<Boolean>? = null,
    public val name: Output<String>,
    public val `return`: Output<Boolean>? = null,
    public val search: Output<Boolean>? = null,
    public val sort: Output<Boolean>? = null,
    public val sourceFields: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cloudsearch.inputs.DomainIndexFieldArgs> {
    override fun toJava(): com.pulumi.aws.cloudsearch.inputs.DomainIndexFieldArgs =
        com.pulumi.aws.cloudsearch.inputs.DomainIndexFieldArgs.builder()
            .analysisScheme(analysisScheme?.applyValue({ args0 -> args0 }))
            .defaultValue(defaultValue?.applyValue({ args0 -> args0 }))
            .facet(facet?.applyValue({ args0 -> args0 }))
            .highlight(highlight?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .return_(`return`?.applyValue({ args0 -> args0 }))
            .search(search?.applyValue({ args0 -> args0 }))
            .sort(sort?.applyValue({ args0 -> args0 }))
            .sourceFields(sourceFields?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainIndexFieldArgs].
 */
@PulumiTagMarker
public class DomainIndexFieldArgsBuilder internal constructor() {
    private var analysisScheme: Output<String>? = null

    private var defaultValue: Output<String>? = null

    private var facet: Output<Boolean>? = null

    private var highlight: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var `return`: Output<Boolean>? = null

    private var search: Output<Boolean>? = null

    private var sort: Output<Boolean>? = null

    private var sourceFields: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The analysis scheme you want to use for a `text` field. The analysis scheme specifies the language-specific text processing options that are used during indexing.
     */
    @JvmName("tmwjwvtukkovaxdi")
    public suspend fun analysisScheme(`value`: Output<String>) {
        this.analysisScheme = value
    }

    /**
     * @param value The default value for the field. This value is used when no value is specified for the field in the document data.
     */
    @JvmName("uykwxlvlkmyrgbkk")
    public suspend fun defaultValue(`value`: Output<String>) {
        this.defaultValue = value
    }

    /**
     * @param value You can get facet information by enabling this.
     */
    @JvmName("oxnsywryomelllfc")
    public suspend fun facet(`value`: Output<Boolean>) {
        this.facet = value
    }

    /**
     * @param value You can highlight information.
     */
    @JvmName("imqkrhkovtpbmldq")
    public suspend fun highlight(`value`: Output<Boolean>) {
        this.highlight = value
    }

    /**
     * @param value A unique name for the field. Field names must begin with a letter and be at least 1 and no more than 64 characters long. The allowed characters are: `a`-`z` (lower-case letters), `0`-`9`, and `_` (underscore). The name `score` is reserved and cannot be used as a field name.
     */
    @JvmName("ervfyapsnqmvfriy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value You can enable returning the value of all searchable fields.
     */
    @JvmName("jgobpoyaahqkppao")
    public suspend fun `return`(`value`: Output<Boolean>) {
        this.`return` = value
    }

    /**
     * @param value You can set whether this index should be searchable or not.
     */
    @JvmName("jogksplgixeghchp")
    public suspend fun search(`value`: Output<Boolean>) {
        this.search = value
    }

    /**
     * @param value You can enable the property to be sortable.
     */
    @JvmName("jmudhtyycajvavab")
    public suspend fun sort(`value`: Output<Boolean>) {
        this.sort = value
    }

    /**
     * @param value A comma-separated list of source fields to map to the field. Specifying a source field copies data from one field to another, enabling you to use the same source data in different ways by configuring different options for the fields.
     */
    @JvmName("dtlaoipaajkplgwe")
    public suspend fun sourceFields(`value`: Output<String>) {
        this.sourceFields = value
    }

    /**
     * @param value The field type. Valid values: `date`, `date-array`, `double`, `double-array`, `int`, `int-array`, `literal`, `literal-array`, `text`, `text-array`.
     */
    @JvmName("ebwuaqbrjposfxly")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The analysis scheme you want to use for a `text` field. The analysis scheme specifies the language-specific text processing options that are used during indexing.
     */
    @JvmName("aniwvovfqfumjkwv")
    public suspend fun analysisScheme(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.analysisScheme = mapped
    }

    /**
     * @param value The default value for the field. This value is used when no value is specified for the field in the document data.
     */
    @JvmName("smelyvftcfskvaqs")
    public suspend fun defaultValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultValue = mapped
    }

    /**
     * @param value You can get facet information by enabling this.
     */
    @JvmName("txwvariuhrcrtxvn")
    public suspend fun facet(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.facet = mapped
    }

    /**
     * @param value You can highlight information.
     */
    @JvmName("pxhoqtcmwxlpkbjx")
    public suspend fun highlight(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.highlight = mapped
    }

    /**
     * @param value A unique name for the field. Field names must begin with a letter and be at least 1 and no more than 64 characters long. The allowed characters are: `a`-`z` (lower-case letters), `0`-`9`, and `_` (underscore). The name `score` is reserved and cannot be used as a field name.
     */
    @JvmName("txxktnkjoqspkdxh")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value You can enable returning the value of all searchable fields.
     */
    @JvmName("utmrgbqqeknhkojk")
    public suspend fun `return`(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`return` = mapped
    }

    /**
     * @param value You can set whether this index should be searchable or not.
     */
    @JvmName("kwcrqmybiwuutmsm")
    public suspend fun search(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.search = mapped
    }

    /**
     * @param value You can enable the property to be sortable.
     */
    @JvmName("sntsxtfpcpbtldll")
    public suspend fun sort(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sort = mapped
    }

    /**
     * @param value A comma-separated list of source fields to map to the field. Specifying a source field copies data from one field to another, enabling you to use the same source data in different ways by configuring different options for the fields.
     */
    @JvmName("lmfyqpxogxicfsgc")
    public suspend fun sourceFields(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceFields = mapped
    }

    /**
     * @param value The field type. Valid values: `date`, `date-array`, `double`, `double-array`, `int`, `int-array`, `literal`, `literal-array`, `text`, `text-array`.
     */
    @JvmName("hidqyimgcvnkapve")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DomainIndexFieldArgs = DomainIndexFieldArgs(
        analysisScheme = analysisScheme,
        defaultValue = defaultValue,
        facet = facet,
        highlight = highlight,
        name = name ?: throw PulumiNullFieldException("name"),
        `return` = `return`,
        search = search,
        sort = sort,
        sourceFields = sourceFields,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
