@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudsearch.kotlin.inputs

import com.pulumi.aws.cloudsearch.inputs.DomainScalingParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property desiredInstanceType The instance type that you want to preconfigure for your domain. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_ScalingParameters.html) for valid values.
 * @property desiredPartitionCount The number of partitions you want to preconfigure for your domain. Only valid when you select `search.2xlarge` as the instance type.
 * @property desiredReplicationCount The number of replicas you want to preconfigure for each index partition.
 */
public data class DomainScalingParametersArgs(
    public val desiredInstanceType: Output<String>? = null,
    public val desiredPartitionCount: Output<Int>? = null,
    public val desiredReplicationCount: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudsearch.inputs.DomainScalingParametersArgs> {
    override fun toJava(): com.pulumi.aws.cloudsearch.inputs.DomainScalingParametersArgs =
        com.pulumi.aws.cloudsearch.inputs.DomainScalingParametersArgs.builder()
            .desiredInstanceType(desiredInstanceType?.applyValue({ args0 -> args0 }))
            .desiredPartitionCount(desiredPartitionCount?.applyValue({ args0 -> args0 }))
            .desiredReplicationCount(desiredReplicationCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainScalingParametersArgs].
 */
@PulumiTagMarker
public class DomainScalingParametersArgsBuilder internal constructor() {
    private var desiredInstanceType: Output<String>? = null

    private var desiredPartitionCount: Output<Int>? = null

    private var desiredReplicationCount: Output<Int>? = null

    /**
     * @param value The instance type that you want to preconfigure for your domain. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_ScalingParameters.html) for valid values.
     */
    @JvmName("kffwutymysswynpj")
    public suspend fun desiredInstanceType(`value`: Output<String>) {
        this.desiredInstanceType = value
    }

    /**
     * @param value The number of partitions you want to preconfigure for your domain. Only valid when you select `search.2xlarge` as the instance type.
     */
    @JvmName("vjwgohlswtirigpj")
    public suspend fun desiredPartitionCount(`value`: Output<Int>) {
        this.desiredPartitionCount = value
    }

    /**
     * @param value The number of replicas you want to preconfigure for each index partition.
     */
    @JvmName("ndlbkdjhaeqxwtlk")
    public suspend fun desiredReplicationCount(`value`: Output<Int>) {
        this.desiredReplicationCount = value
    }

    /**
     * @param value The instance type that you want to preconfigure for your domain. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_ScalingParameters.html) for valid values.
     */
    @JvmName("nssmnawvdjhdbwxb")
    public suspend fun desiredInstanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredInstanceType = mapped
    }

    /**
     * @param value The number of partitions you want to preconfigure for your domain. Only valid when you select `search.2xlarge` as the instance type.
     */
    @JvmName("fpowtctkvmfcjvwf")
    public suspend fun desiredPartitionCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredPartitionCount = mapped
    }

    /**
     * @param value The number of replicas you want to preconfigure for each index partition.
     */
    @JvmName("fdomyirkuhssqfdi")
    public suspend fun desiredReplicationCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredReplicationCount = mapped
    }

    internal fun build(): DomainScalingParametersArgs = DomainScalingParametersArgs(
        desiredInstanceType = desiredInstanceType,
        desiredPartitionCount = desiredPartitionCount,
        desiredReplicationCount = desiredReplicationCount,
    )
}
