@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudsearch.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enforceHttps Enables or disables the requirement that all requests to the domain arrive over HTTPS.
 * @property tlsSecurityPolicy The minimum required TLS version. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DomainEndpointOptions.html) for valid values.
 */
public data class DomainEndpointOptions(
    public val enforceHttps: Boolean? = null,
    public val tlsSecurityPolicy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudsearch.outputs.DomainEndpointOptions): DomainEndpointOptions = DomainEndpointOptions(
            enforceHttps = javaType.enforceHttps().map({ args0 -> args0 }).orElse(null),
            tlsSecurityPolicy = javaType.tlsSecurityPolicy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
