@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudsearch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property desiredInstanceType The instance type that you want to preconfigure for your domain. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_ScalingParameters.html) for valid values.
 * @property desiredPartitionCount The number of partitions you want to preconfigure for your domain. Only valid when you select `search.2xlarge` as the instance type.
 * @property desiredReplicationCount The number of replicas you want to preconfigure for each index partition.
 */
public data class DomainScalingParameters(
    public val desiredInstanceType: String? = null,
    public val desiredPartitionCount: Int? = null,
    public val desiredReplicationCount: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudsearch.outputs.DomainScalingParameters): DomainScalingParameters = DomainScalingParameters(
            desiredInstanceType = javaType.desiredInstanceType().map({ args0 -> args0 }).orElse(null),
            desiredPartitionCount = javaType.desiredPartitionCount().map({ args0 -> args0 }).orElse(null),
            desiredReplicationCount = javaType.desiredReplicationCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
