@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudtrail.kotlin

import com.pulumi.aws.cloudtrail.EventDataStoreArgs.builder
import com.pulumi.aws.cloudtrail.kotlin.inputs.EventDataStoreAdvancedEventSelectorArgs
import com.pulumi.aws.cloudtrail.kotlin.inputs.EventDataStoreAdvancedEventSelectorArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CloudTrail Event Data Store.
 * More information about event data stores can be found in the [Event Data Store User Guide](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html).
 * > **Tip:** For an organization event data store you must create this resource in the management account.
 * ## Example Usage
 * ### Basic
 * The most simple event data store configuration requires us to only set the `name` attribute. The event data store will automatically capture all management events. To capture management events from all the regions, `multi_region_enabled` must be `true`.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudtrail.EventDataStore("example", {name: "example-event-data-store"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudtrail.EventDataStore("example", name="example-event-data-store")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudTrail.EventDataStore("example", new()
 *     {
 *         Name = "example-event-data-store",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudtrail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudtrail.NewEventDataStore(ctx, "example", &cloudtrail.EventDataStoreArgs{
 * 			Name: pulumi.String("example-event-data-store"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudtrail.EventDataStore;
 * import com.pulumi.aws.cloudtrail.EventDataStoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventDataStore("example", EventDataStoreArgs.builder()
 *             .name("example-event-data-store")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudtrail:EventDataStore
 *     properties:
 *       name: example-event-data-store
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Data Event Logging
 * CloudTrail can log [Data Events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html) for certain services such as S3 bucket objects and Lambda function invocations. Additional information about data event configuration can be found in the following links:
 * - [CloudTrail API AdvancedFieldSelector documentation](https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedFieldSelector.html)
 * ### Log all DynamoDB PutEvent actions for a specific DynamoDB table
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const table = aws.dynamodb.getTable({
 *     name: "not-important-dynamodb-table",
 * });
 * const example = new aws.cloudtrail.EventDataStore("example", {advancedEventSelectors: [{
 *     name: "Log all DynamoDB PutEvent actions for a specific DynamoDB table",
 *     fieldSelectors: [
 *         {
 *             field: "eventCategory",
 *             equals: ["Data"],
 *         },
 *         {
 *             field: "resources.type",
 *             equals: ["AWS::DynamoDB::Table"],
 *         },
 *         {
 *             field: "eventName",
 *             equals: ["PutItem"],
 *         },
 *         {
 *             field: "resources.ARN",
 *             equals: [table&#46;then(table => table&#46;arn)],
 *         },
 *     ],
 * }]});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * table = aws.dynamodb.get_table(name="not-important-dynamodb-table")
 * example = aws.cloudtrail.EventDataStore("example", advanced_event_selectors=[{
 *     "name": "Log all DynamoDB PutEvent actions for a specific DynamoDB table",
 *     "field_selectors": [
 *         {
 *             "field": "eventCategory",
 *             "equals": ["Data"],
 *         },
 *         {
 *             "field": "resources.type",
 *             "equals": ["AWS::DynamoDB::Table"],
 *         },
 *         {
 *             "field": "eventName",
 *             "equals": ["PutItem"],
 *         },
 *         {
 *             "field": "resources.ARN",
 *             "equals": [table&#46;arn],
 *         },
 *     ],
 * }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var table = Aws.DynamoDB.GetTable.Invoke(new()
 *     {
 *         Name = "not-important-dynamodb-table",
 *     });
 *     var example = new Aws.CloudTrail.EventDataStore("example", new()
 *     {
 *         AdvancedEventSelectors = new[]
 *         {
 *             new Aws.CloudTrail.Inputs.EventDataStoreAdvancedEventSelectorArgs
 *             {
 *                 Name = "Log all DynamoDB PutEvent actions for a specific DynamoDB table",
 *                 FieldSelectors = new[]
 *                 {
 *                     new Aws.CloudTrail.Inputs.EventDataStoreAdvancedEventSelectorFieldSelectorArgs
 *                     {
 *                         Field = "eventCategory",
 *                         Equals = new[]
 *                         {
 *                             "Data",
 *                         },
 *                     },
 *                     new Aws.CloudTrail.Inputs.EventDataStoreAdvancedEventSelectorFieldSelectorArgs
 *                     {
 *                         Field = "resources.type",
 *                         Equals = new[]
 *                         {
 *                             "AWS::DynamoDB::Table",
 *                         },
 *                     },
 *                     new Aws.CloudTrail.Inputs.EventDataStoreAdvancedEventSelectorFieldSelectorArgs
 *                     {
 *                         Field = "eventName",
 *                         Equals = new[]
 *                         {
 *                             "PutItem",
 *                         },
 *                     },
 *                     new Aws.CloudTrail.Inputs.EventDataStoreAdvancedEventSelectorFieldSelectorArgs
 *                     {
 *                         Field = "resources.ARN",
 *                         Equals = new[]
 *                         {
 *                             table.Apply(getTableResult => getTableResult.Arn),
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudtrail"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dynamodb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		table, err := dynamodb.LookupTable(ctx, &dynamodb.LookupTableArgs{
 * 			Name: "not-important-dynamodb-table",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudtrail.NewEventDataStore(ctx, "example", &cloudtrail.EventDataStoreArgs{
 * 			AdvancedEventSelectors: cloudtrail.EventDataStoreAdvancedEventSelectorArray{
 * 				&cloudtrail.EventDataStoreAdvancedEventSelectorArgs{
 * 					Name: pulumi.String("Log all DynamoDB PutEvent actions for a specific DynamoDB table"),
 * 					FieldSelectors: cloudtrail.EventDataStoreAdvancedEventSelectorFieldSelectorArray{
 * 						&cloudtrail.EventDataStoreAdvancedEventSelectorFieldSelectorArgs{
 * 							Field: pulumi.String("eventCategory"),
 * 							Equals: pulumi.StringArray{
 * 								pulumi.String("Data"),
 * 							},
 * 						},
 * 						&cloudtrail.EventDataStoreAdvancedEventSelectorFieldSelectorArgs{
 * 							Field: pulumi.String("resources.type"),
 * 							Equals: pulumi.StringArray{
 * 								pulumi.String("AWS::DynamoDB::Table"),
 * 							},
 * 						},
 * 						&cloudtrail.EventDataStoreAdvancedEventSelectorFieldSelectorArgs{
 * 							Field: pulumi.String("eventName"),
 * 							Equals: pulumi.StringArray{
 * 								pulumi.String("PutItem"),
 * 							},
 * 						},
 * 						&cloudtrail.EventDataStoreAdvancedEventSelectorFieldSelectorArgs{
 * 							Field: pulumi.String("resources.ARN"),
 * 							Equals: pulumi.StringArray{
 * 								pulumi.String(table.Arn),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dynamodb.DynamodbFunctions;
 * import com.pulumi.aws.dynamodb.inputs.GetTableArgs;
 * import com.pulumi.aws.cloudtrail.EventDataStore;
 * import com.pulumi.aws.cloudtrail.EventDataStoreArgs;
 * import com.pulumi.aws.cloudtrail.inputs.EventDataStoreAdvancedEventSelectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var table = DynamodbFunctions.getTable(GetTableArgs.builder()
 *             .name("not-important-dynamodb-table")
 *             .build());
 *         var example = new EventDataStore("example", EventDataStoreArgs.builder()
 *             .advancedEventSelectors(EventDataStoreAdvancedEventSelectorArgs.builder()
 *                 .name("Log all DynamoDB PutEvent actions for a specific DynamoDB table")
 *                 .fieldSelectors(
 *                     EventDataStoreAdvancedEventSelectorFieldSelectorArgs.builder()
 *                         .field("eventCategory")
 *                         .equals("Data")
 *                         .build(),
 *                     EventDataStoreAdvancedEventSelectorFieldSelectorArgs.builder()
 *                         .field("resources.type")
 *                         .equals("AWS::DynamoDB::Table")
 *                         .build(),
 *                     EventDataStoreAdvancedEventSelectorFieldSelectorArgs.builder()
 *                         .field("eventName")
 *                         .equals("PutItem")
 *                         .build(),
 *                     EventDataStoreAdvancedEventSelectorFieldSelectorArgs.builder()
 *                         .field("resources.ARN")
 *                         .equals(table.applyValue(getTableResult -> getTableResult.arn()))
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudtrail:EventDataStore
 *     properties:
 *       advancedEventSelectors:
 *         - name: Log all DynamoDB PutEvent actions for a specific DynamoDB table
 *           fieldSelectors:
 *             - field: eventCategory
 *               equals:
 *                 - Data
 *             - field: resources.type
 *               equals:
 *                 - AWS::DynamoDB::Table
 *             - field: eventName
 *               equals:
 *                 - PutItem
 *             - field: resources.ARN
 *               equals:
 *                 - ${table.arn}
 * variables:
 *   table:
 *     fn::invoke:
 *       Function: aws:dynamodb:getTable
 *       Arguments:
 *         name: not-important-dynamodb-table
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import event data stores using their `arn`. For example:
 * ```sh
 * $ pulumi import aws:cloudtrail/eventDataStore:EventDataStore example arn:aws:cloudtrail:us-east-1:123456789123:eventdatastore/22333815-4414-412c-b155-dd254033gfhf
 * ```
 * @property advancedEventSelectors The advanced event selectors to use to select the events for the data store. For more information about how to use advanced event selectors, see [Log events by using advanced event selectors](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced) in the CloudTrail User Guide.
 * @property billingMode The billing mode for the event data store. The valid values are `EXTENDABLE_RETENTION_PRICING` and `FIXED_RETENTION_PRICING`. Defaults to `EXTENDABLE_RETENTION_PRICING`.
 * @property kmsKeyId Specifies the AWS KMS key ID to use to encrypt the events delivered by CloudTrail. The value can be an alias name prefixed by alias/, a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
 * @property multiRegionEnabled Specifies whether the event data store includes events from all regions, or only from the region in which the event data store is created. Default: `true`.
 * @property name The name of the event data store.
 * @property organizationEnabled Specifies whether an event data store collects events logged for an organization in AWS Organizations. Default: `false`.
 * @property retentionPeriod The retention period of the event data store, in days. You can set a retention period of up to 2555 days, the equivalent of seven years. Default: `2555`.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property terminationProtectionEnabled Specifies whether termination protection is enabled for the event data store. If termination protection is enabled, you cannot delete the event data store until termination protection is disabled. Default: `true`.
 */
public data class EventDataStoreArgs(
    public val advancedEventSelectors: Output<List<EventDataStoreAdvancedEventSelectorArgs>>? = null,
    public val billingMode: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val multiRegionEnabled: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val organizationEnabled: Output<Boolean>? = null,
    public val retentionPeriod: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val terminationProtectionEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudtrail.EventDataStoreArgs> {
    override fun toJava(): com.pulumi.aws.cloudtrail.EventDataStoreArgs =
        com.pulumi.aws.cloudtrail.EventDataStoreArgs.builder()
            .advancedEventSelectors(
                advancedEventSelectors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .billingMode(billingMode?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .multiRegionEnabled(multiRegionEnabled?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .organizationEnabled(organizationEnabled?.applyValue({ args0 -> args0 }))
            .retentionPeriod(retentionPeriod?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .terminationProtectionEnabled(terminationProtectionEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventDataStoreArgs].
 */
@PulumiTagMarker
public class EventDataStoreArgsBuilder internal constructor() {
    private var advancedEventSelectors: Output<List<EventDataStoreAdvancedEventSelectorArgs>>? = null

    private var billingMode: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var multiRegionEnabled: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var organizationEnabled: Output<Boolean>? = null

    private var retentionPeriod: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var terminationProtectionEnabled: Output<Boolean>? = null

    /**
     * @param value The advanced event selectors to use to select the events for the data store. For more information about how to use advanced event selectors, see [Log events by using advanced event selectors](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced) in the CloudTrail User Guide.
     */
    @JvmName("fwklfdlxlqqcojvo")
    public suspend fun advancedEventSelectors(`value`: Output<List<EventDataStoreAdvancedEventSelectorArgs>>) {
        this.advancedEventSelectors = value
    }

    @JvmName("lxxaneqtyofxgety")
    public suspend fun advancedEventSelectors(vararg values: Output<EventDataStoreAdvancedEventSelectorArgs>) {
        this.advancedEventSelectors = Output.all(values.asList())
    }

    /**
     * @param values The advanced event selectors to use to select the events for the data store. For more information about how to use advanced event selectors, see [Log events by using advanced event selectors](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced) in the CloudTrail User Guide.
     */
    @JvmName("dbpeffaiwuxlwlpf")
    public suspend fun advancedEventSelectors(values: List<Output<EventDataStoreAdvancedEventSelectorArgs>>) {
        this.advancedEventSelectors = Output.all(values)
    }

    /**
     * @param value The billing mode for the event data store. The valid values are `EXTENDABLE_RETENTION_PRICING` and `FIXED_RETENTION_PRICING`. Defaults to `EXTENDABLE_RETENTION_PRICING`.
     */
    @JvmName("bjnbifnmoepcacpi")
    public suspend fun billingMode(`value`: Output<String>) {
        this.billingMode = value
    }

    /**
     * @param value Specifies the AWS KMS key ID to use to encrypt the events delivered by CloudTrail. The value can be an alias name prefixed by alias/, a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
     */
    @JvmName("fnqewjkrwhmlheht")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Specifies whether the event data store includes events from all regions, or only from the region in which the event data store is created. Default: `true`.
     */
    @JvmName("fybjmpcmvnywsvqg")
    public suspend fun multiRegionEnabled(`value`: Output<Boolean>) {
        this.multiRegionEnabled = value
    }

    /**
     * @param value The name of the event data store.
     */
    @JvmName("yvgdprdljfebkgtx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies whether an event data store collects events logged for an organization in AWS Organizations. Default: `false`.
     */
    @JvmName("gayfejotcqrdndnv")
    public suspend fun organizationEnabled(`value`: Output<Boolean>) {
        this.organizationEnabled = value
    }

    /**
     * @param value The retention period of the event data store, in days. You can set a retention period of up to 2555 days, the equivalent of seven years. Default: `2555`.
     */
    @JvmName("mikhdcydqwtnjcuw")
    public suspend fun retentionPeriod(`value`: Output<Int>) {
        this.retentionPeriod = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mavvlxoxamfbleis")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies whether termination protection is enabled for the event data store. If termination protection is enabled, you cannot delete the event data store until termination protection is disabled. Default: `true`.
     */
    @JvmName("uipdfkachqnfggyy")
    public suspend fun terminationProtectionEnabled(`value`: Output<Boolean>) {
        this.terminationProtectionEnabled = value
    }

    /**
     * @param value The advanced event selectors to use to select the events for the data store. For more information about how to use advanced event selectors, see [Log events by using advanced event selectors](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced) in the CloudTrail User Guide.
     */
    @JvmName("snonubltpvnipkeq")
    public suspend fun advancedEventSelectors(`value`: List<EventDataStoreAdvancedEventSelectorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advancedEventSelectors = mapped
    }

    /**
     * @param argument The advanced event selectors to use to select the events for the data store. For more information about how to use advanced event selectors, see [Log events by using advanced event selectors](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced) in the CloudTrail User Guide.
     */
    @JvmName("oggstwatwvkjvftt")
    public suspend fun advancedEventSelectors(argument: List<suspend EventDataStoreAdvancedEventSelectorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventDataStoreAdvancedEventSelectorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.advancedEventSelectors = mapped
    }

    /**
     * @param argument The advanced event selectors to use to select the events for the data store. For more information about how to use advanced event selectors, see [Log events by using advanced event selectors](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced) in the CloudTrail User Guide.
     */
    @JvmName("hbscklhgujqynrgm")
    public suspend fun advancedEventSelectors(vararg argument: suspend EventDataStoreAdvancedEventSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EventDataStoreAdvancedEventSelectorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.advancedEventSelectors = mapped
    }

    /**
     * @param argument The advanced event selectors to use to select the events for the data store. For more information about how to use advanced event selectors, see [Log events by using advanced event selectors](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced) in the CloudTrail User Guide.
     */
    @JvmName("ntdevaqneyxexoan")
    public suspend fun advancedEventSelectors(argument: suspend EventDataStoreAdvancedEventSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EventDataStoreAdvancedEventSelectorArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.advancedEventSelectors = mapped
    }

    /**
     * @param values The advanced event selectors to use to select the events for the data store. For more information about how to use advanced event selectors, see [Log events by using advanced event selectors](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced) in the CloudTrail User Guide.
     */
    @JvmName("gkdkmxhhcbvibyin")
    public suspend fun advancedEventSelectors(vararg values: EventDataStoreAdvancedEventSelectorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.advancedEventSelectors = mapped
    }

    /**
     * @param value The billing mode for the event data store. The valid values are `EXTENDABLE_RETENTION_PRICING` and `FIXED_RETENTION_PRICING`. Defaults to `EXTENDABLE_RETENTION_PRICING`.
     */
    @JvmName("osvladeppilcnysw")
    public suspend fun billingMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingMode = mapped
    }

    /**
     * @param value Specifies the AWS KMS key ID to use to encrypt the events delivered by CloudTrail. The value can be an alias name prefixed by alias/, a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
     */
    @JvmName("rxgbamatgwcnkxkw")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Specifies whether the event data store includes events from all regions, or only from the region in which the event data store is created. Default: `true`.
     */
    @JvmName("tpmjeowosdnlfldf")
    public suspend fun multiRegionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiRegionEnabled = mapped
    }

    /**
     * @param value The name of the event data store.
     */
    @JvmName("yvtxrumpvostvmem")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies whether an event data store collects events logged for an organization in AWS Organizations. Default: `false`.
     */
    @JvmName("hbdspgnthlrcoqaq")
    public suspend fun organizationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationEnabled = mapped
    }

    /**
     * @param value The retention period of the event data store, in days. You can set a retention period of up to 2555 days, the equivalent of seven years. Default: `2555`.
     */
    @JvmName("nawtelvbudofogjv")
    public suspend fun retentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPeriod = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qkpaxmwwjefygalj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lhtxebhldpnphate")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies whether termination protection is enabled for the event data store. If termination protection is enabled, you cannot delete the event data store until termination protection is disabled. Default: `true`.
     */
    @JvmName("wvpvhwakbvnagdem")
    public suspend fun terminationProtectionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminationProtectionEnabled = mapped
    }

    internal fun build(): EventDataStoreArgs = EventDataStoreArgs(
        advancedEventSelectors = advancedEventSelectors,
        billingMode = billingMode,
        kmsKeyId = kmsKeyId,
        multiRegionEnabled = multiRegionEnabled,
        name = name,
        organizationEnabled = organizationEnabled,
        retentionPeriod = retentionPeriod,
        tags = tags,
        terminationProtectionEnabled = terminationProtectionEnabled,
    )
}
