@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudtrail.kotlin.inputs

import com.pulumi.aws.cloudtrail.inputs.EventDataStoreAdvancedEventSelectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property fieldSelectors Specifies the selector statements in an advanced event selector. Fields documented below.
 * @property name Specifies the name of the advanced event selector.
 */
public data class EventDataStoreAdvancedEventSelectorArgs(
    public val fieldSelectors: Output<List<EventDataStoreAdvancedEventSelectorFieldSelectorArgs>>? =
        null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudtrail.inputs.EventDataStoreAdvancedEventSelectorArgs> {
    override fun toJava(): com.pulumi.aws.cloudtrail.inputs.EventDataStoreAdvancedEventSelectorArgs =
        com.pulumi.aws.cloudtrail.inputs.EventDataStoreAdvancedEventSelectorArgs.builder()
            .fieldSelectors(
                fieldSelectors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventDataStoreAdvancedEventSelectorArgs].
 */
@PulumiTagMarker
public class EventDataStoreAdvancedEventSelectorArgsBuilder internal constructor() {
    private var fieldSelectors: Output<List<EventDataStoreAdvancedEventSelectorFieldSelectorArgs>>? =
        null

    private var name: Output<String>? = null

    /**
     * @param value Specifies the selector statements in an advanced event selector. Fields documented below.
     */
    @JvmName("ehsnfusqkequfkoi")
    public suspend fun fieldSelectors(`value`: Output<List<EventDataStoreAdvancedEventSelectorFieldSelectorArgs>>) {
        this.fieldSelectors = value
    }

    @JvmName("ktwghnmxkchalvwx")
    public suspend fun fieldSelectors(vararg values: Output<EventDataStoreAdvancedEventSelectorFieldSelectorArgs>) {
        this.fieldSelectors = Output.all(values.asList())
    }

    /**
     * @param values Specifies the selector statements in an advanced event selector. Fields documented below.
     */
    @JvmName("ucpidrkcmathwrwq")
    public suspend fun fieldSelectors(values: List<Output<EventDataStoreAdvancedEventSelectorFieldSelectorArgs>>) {
        this.fieldSelectors = Output.all(values)
    }

    /**
     * @param value Specifies the name of the advanced event selector.
     */
    @JvmName("cseptlikoxtdycck")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the selector statements in an advanced event selector. Fields documented below.
     */
    @JvmName("gjgdggexyvugnlvb")
    public suspend fun fieldSelectors(`value`: List<EventDataStoreAdvancedEventSelectorFieldSelectorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldSelectors = mapped
    }

    /**
     * @param argument Specifies the selector statements in an advanced event selector. Fields documented below.
     */
    @JvmName("xjgtkaobglfhircs")
    public suspend fun fieldSelectors(argument: List<suspend EventDataStoreAdvancedEventSelectorFieldSelectorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventDataStoreAdvancedEventSelectorFieldSelectorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.fieldSelectors = mapped
    }

    /**
     * @param argument Specifies the selector statements in an advanced event selector. Fields documented below.
     */
    @JvmName("cvnqdlfyuneirdba")
    public suspend fun fieldSelectors(vararg argument: suspend EventDataStoreAdvancedEventSelectorFieldSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EventDataStoreAdvancedEventSelectorFieldSelectorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.fieldSelectors = mapped
    }

    /**
     * @param argument Specifies the selector statements in an advanced event selector. Fields documented below.
     */
    @JvmName("buiqhrahpjfwvdtc")
    public suspend fun fieldSelectors(argument: suspend EventDataStoreAdvancedEventSelectorFieldSelectorArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                EventDataStoreAdvancedEventSelectorFieldSelectorArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.fieldSelectors = mapped
    }

    /**
     * @param values Specifies the selector statements in an advanced event selector. Fields documented below.
     */
    @JvmName("ldbmoyoadiclqllw")
    public suspend fun fieldSelectors(vararg values: EventDataStoreAdvancedEventSelectorFieldSelectorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldSelectors = mapped
    }

    /**
     * @param value Specifies the name of the advanced event selector.
     */
    @JvmName("mpqvqqpjhpmbckoa")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): EventDataStoreAdvancedEventSelectorArgs =
        EventDataStoreAdvancedEventSelectorArgs(
            fieldSelectors = fieldSelectors,
            name = name,
        )
}
