@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudtrail.kotlin.inputs

import com.pulumi.aws.cloudtrail.inputs.EventDataStoreAdvancedEventSelectorFieldSelectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property endsWiths A list of values that includes events that match the last few characters of the event record field specified as the value of `field`.
 * @property equals A list of values that includes events that match the exact value of the event record field specified as the value of `field`. This is the only valid operator that you can use with the `readOnly`, `eventCategory`, and `resources.type` fields.
 * @property field Specifies a field in an event record on which to filter events to be logged. You can specify only the following values: `readOnly`, `eventSource`, `eventName`, `eventCategory`, `resources.type`, `resources.ARN`.
 * @property notEndsWiths A list of values that excludes events that match the last few characters of the event record field specified as the value of `field`.
 * @property notEquals A list of values that excludes events that match the exact value of the event record field specified as the value of `field`.
 * @property notStartsWiths A list of values that excludes events that match the first few characters of the event record field specified as the value of `field`.
 * @property startsWiths A list of values that includes events that match the first few characters of the event record field specified as the value of `field`.
 */
public data class EventDataStoreAdvancedEventSelectorFieldSelectorArgs(
    public val endsWiths: Output<List<String>>? = null,
    public val equals: Output<List<String>>? = null,
    public val `field`: Output<String>? = null,
    public val notEndsWiths: Output<List<String>>? = null,
    public val notEquals: Output<List<String>>? = null,
    public val notStartsWiths: Output<List<String>>? = null,
    public val startsWiths: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudtrail.inputs.EventDataStoreAdvancedEventSelectorFieldSelectorArgs> {
    override fun toJava(): com.pulumi.aws.cloudtrail.inputs.EventDataStoreAdvancedEventSelectorFieldSelectorArgs =
        com.pulumi.aws.cloudtrail.inputs.EventDataStoreAdvancedEventSelectorFieldSelectorArgs.builder()
            .endsWiths(endsWiths?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .equals_(equals?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .`field`(`field`?.applyValue({ args0 -> args0 }))
            .notEndsWiths(notEndsWiths?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .notEquals(notEquals?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .notStartsWiths(notStartsWiths?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .startsWiths(startsWiths?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [EventDataStoreAdvancedEventSelectorFieldSelectorArgs].
 */
@PulumiTagMarker
public class EventDataStoreAdvancedEventSelectorFieldSelectorArgsBuilder internal constructor() {
    private var endsWiths: Output<List<String>>? = null

    private var equals: Output<List<String>>? = null

    private var `field`: Output<String>? = null

    private var notEndsWiths: Output<List<String>>? = null

    private var notEquals: Output<List<String>>? = null

    private var notStartsWiths: Output<List<String>>? = null

    private var startsWiths: Output<List<String>>? = null

    /**
     * @param value A list of values that includes events that match the last few characters of the event record field specified as the value of `field`.
     */
    @JvmName("vphdoehtifvhrmic")
    public suspend fun endsWiths(`value`: Output<List<String>>) {
        this.endsWiths = value
    }

    @JvmName("keqpvlbkewbiasel")
    public suspend fun endsWiths(vararg values: Output<String>) {
        this.endsWiths = Output.all(values.asList())
    }

    /**
     * @param values A list of values that includes events that match the last few characters of the event record field specified as the value of `field`.
     */
    @JvmName("exroheefvjjtxepr")
    public suspend fun endsWiths(values: List<Output<String>>) {
        this.endsWiths = Output.all(values)
    }

    /**
     * @param value A list of values that includes events that match the exact value of the event record field specified as the value of `field`. This is the only valid operator that you can use with the `readOnly`, `eventCategory`, and `resources.type` fields.
     */
    @JvmName("skjojpvbusxmgelj")
    public suspend fun equals(`value`: Output<List<String>>) {
        this.equals = value
    }

    @JvmName("ciurfjtmebqtdmed")
    public suspend fun equals(vararg values: Output<String>) {
        this.equals = Output.all(values.asList())
    }

    /**
     * @param values A list of values that includes events that match the exact value of the event record field specified as the value of `field`. This is the only valid operator that you can use with the `readOnly`, `eventCategory`, and `resources.type` fields.
     */
    @JvmName("uaaoxknpsjuckneh")
    public suspend fun equals(values: List<Output<String>>) {
        this.equals = Output.all(values)
    }

    /**
     * @param value Specifies a field in an event record on which to filter events to be logged. You can specify only the following values: `readOnly`, `eventSource`, `eventName`, `eventCategory`, `resources.type`, `resources.ARN`.
     */
    @JvmName("mesfigibeytoigwn")
    public suspend fun `field`(`value`: Output<String>) {
        this.`field` = value
    }

    /**
     * @param value A list of values that excludes events that match the last few characters of the event record field specified as the value of `field`.
     */
    @JvmName("joantrrpjgdbqjon")
    public suspend fun notEndsWiths(`value`: Output<List<String>>) {
        this.notEndsWiths = value
    }

    @JvmName("tprvtjohtcaukety")
    public suspend fun notEndsWiths(vararg values: Output<String>) {
        this.notEndsWiths = Output.all(values.asList())
    }

    /**
     * @param values A list of values that excludes events that match the last few characters of the event record field specified as the value of `field`.
     */
    @JvmName("enhwxdkofhkquumu")
    public suspend fun notEndsWiths(values: List<Output<String>>) {
        this.notEndsWiths = Output.all(values)
    }

    /**
     * @param value A list of values that excludes events that match the exact value of the event record field specified as the value of `field`.
     */
    @JvmName("glnbvqmqpohovbfs")
    public suspend fun notEquals(`value`: Output<List<String>>) {
        this.notEquals = value
    }

    @JvmName("mqevcthxawfhnkcs")
    public suspend fun notEquals(vararg values: Output<String>) {
        this.notEquals = Output.all(values.asList())
    }

    /**
     * @param values A list of values that excludes events that match the exact value of the event record field specified as the value of `field`.
     */
    @JvmName("fkunbtgajkbdyxoc")
    public suspend fun notEquals(values: List<Output<String>>) {
        this.notEquals = Output.all(values)
    }

    /**
     * @param value A list of values that excludes events that match the first few characters of the event record field specified as the value of `field`.
     */
    @JvmName("nmvdgqsjfarbrymr")
    public suspend fun notStartsWiths(`value`: Output<List<String>>) {
        this.notStartsWiths = value
    }

    @JvmName("eobwerubgsnexofp")
    public suspend fun notStartsWiths(vararg values: Output<String>) {
        this.notStartsWiths = Output.all(values.asList())
    }

    /**
     * @param values A list of values that excludes events that match the first few characters of the event record field specified as the value of `field`.
     */
    @JvmName("wjcxfoulqvwwtotl")
    public suspend fun notStartsWiths(values: List<Output<String>>) {
        this.notStartsWiths = Output.all(values)
    }

    /**
     * @param value A list of values that includes events that match the first few characters of the event record field specified as the value of `field`.
     */
    @JvmName("lfnbxrburrsgqfxx")
    public suspend fun startsWiths(`value`: Output<List<String>>) {
        this.startsWiths = value
    }

    @JvmName("mrqliwlhjpuhbafn")
    public suspend fun startsWiths(vararg values: Output<String>) {
        this.startsWiths = Output.all(values.asList())
    }

    /**
     * @param values A list of values that includes events that match the first few characters of the event record field specified as the value of `field`.
     */
    @JvmName("wxifsgriffgktqot")
    public suspend fun startsWiths(values: List<Output<String>>) {
        this.startsWiths = Output.all(values)
    }

    /**
     * @param value A list of values that includes events that match the last few characters of the event record field specified as the value of `field`.
     */
    @JvmName("rdumivodmubfwxhw")
    public suspend fun endsWiths(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endsWiths = mapped
    }

    /**
     * @param values A list of values that includes events that match the last few characters of the event record field specified as the value of `field`.
     */
    @JvmName("jruehlmkphweamcq")
    public suspend fun endsWiths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endsWiths = mapped
    }

    /**
     * @param value A list of values that includes events that match the exact value of the event record field specified as the value of `field`. This is the only valid operator that you can use with the `readOnly`, `eventCategory`, and `resources.type` fields.
     */
    @JvmName("kelwlabtxaxuesdq")
    public suspend fun equals(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.equals = mapped
    }

    /**
     * @param values A list of values that includes events that match the exact value of the event record field specified as the value of `field`. This is the only valid operator that you can use with the `readOnly`, `eventCategory`, and `resources.type` fields.
     */
    @JvmName("dsncgdygskgpniuv")
    public suspend fun equals(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.equals = mapped
    }

    /**
     * @param value Specifies a field in an event record on which to filter events to be logged. You can specify only the following values: `readOnly`, `eventSource`, `eventName`, `eventCategory`, `resources.type`, `resources.ARN`.
     */
    @JvmName("vpywwyfmagomlsgd")
    public suspend fun `field`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`field` = mapped
    }

    /**
     * @param value A list of values that excludes events that match the last few characters of the event record field specified as the value of `field`.
     */
    @JvmName("lrtyyptnxqrpjshf")
    public suspend fun notEndsWiths(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notEndsWiths = mapped
    }

    /**
     * @param values A list of values that excludes events that match the last few characters of the event record field specified as the value of `field`.
     */
    @JvmName("rpcuoiaoafmngcnp")
    public suspend fun notEndsWiths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notEndsWiths = mapped
    }

    /**
     * @param value A list of values that excludes events that match the exact value of the event record field specified as the value of `field`.
     */
    @JvmName("ubxfmhtjydgaxjlr")
    public suspend fun notEquals(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notEquals = mapped
    }

    /**
     * @param values A list of values that excludes events that match the exact value of the event record field specified as the value of `field`.
     */
    @JvmName("qqaipxqbmnehgxss")
    public suspend fun notEquals(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notEquals = mapped
    }

    /**
     * @param value A list of values that excludes events that match the first few characters of the event record field specified as the value of `field`.
     */
    @JvmName("kxowkrirearlwtae")
    public suspend fun notStartsWiths(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notStartsWiths = mapped
    }

    /**
     * @param values A list of values that excludes events that match the first few characters of the event record field specified as the value of `field`.
     */
    @JvmName("dvmqodentubucdgn")
    public suspend fun notStartsWiths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notStartsWiths = mapped
    }

    /**
     * @param value A list of values that includes events that match the first few characters of the event record field specified as the value of `field`.
     */
    @JvmName("hemclllbakwulbcr")
    public suspend fun startsWiths(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startsWiths = mapped
    }

    /**
     * @param values A list of values that includes events that match the first few characters of the event record field specified as the value of `field`.
     */
    @JvmName("wtclgqexdmliomwi")
    public suspend fun startsWiths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startsWiths = mapped
    }

    internal fun build(): EventDataStoreAdvancedEventSelectorFieldSelectorArgs =
        EventDataStoreAdvancedEventSelectorFieldSelectorArgs(
            endsWiths = endsWiths,
            equals = equals,
            `field` = `field`,
            notEndsWiths = notEndsWiths,
            notEquals = notEquals,
            notStartsWiths = notStartsWiths,
            startsWiths = startsWiths,
        )
}
